/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.DomainManagementLogger;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.plugin.AuthorizationPlugIn;
import org.jboss.as.domain.management.plugin.PlugInConfigurationSupport;
import org.jboss.as.domain.management.security.AbstractPlugInService;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class PlugInSubjectSupplemental
extends AbstractPlugInService
implements Service<SubjectSupplementalService>,
SubjectSupplementalService {
    private static final String SERVICE_SUFFIX = "plug-in-authorization";

    PlugInSubjectSupplemental(String realmName, String name, Map<String, String> properties) {
        super(realmName, name, properties);
    }

    public SubjectSupplementalService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public SubjectSupplemental getSubjectSupplemental(Map<String, Object> sharedState) {
        String name = this.getPlugInName();
        final AuthorizationPlugIn ap = this.getPlugInLoader().loadAuthorizationPlugIn(name);
        if (ap instanceof PlugInConfigurationSupport) {
            PlugInConfigurationSupport pcf = (PlugInConfigurationSupport)((Object)ap);
            try {
                pcf.init(this.getConfiguration(), sharedState);
            }
            catch (IOException e) {
                throw DomainManagementMessages.MESSAGES.unableToInitialisePlugIn(name, e.getMessage());
            }
        }
        return new SubjectSupplemental(){

            @Override
            public void supplementSubject(Subject subject) throws IOException {
                Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
                Set<Principal> principals = subject.getPrincipals();
                for (RealmUser current : users) {
                    principals.addAll(this.loadGroups(current));
                }
            }

            private Set<RealmGroup> loadGroups(RealmUser user) throws IOException {
                String[] groups = ap.loadRoles(user.getName(), PlugInSubjectSupplemental.this.getRealmName());
                HashSet<RealmGroup> response = new HashSet<RealmGroup>(groups.length);
                for (String current : groups) {
                    RealmGroup newGroup = new RealmGroup(PlugInSubjectSupplemental.this.getRealmName(), current);
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Adding group '%s' for user '%s'.", newGroup, user);
                    response.add(newGroup);
                }
                return response;
            }
        };
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{PlugInSubjectSupplemental.SERVICE_SUFFIX});
        }
    }
}

