/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.logging;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentIsStoppedException;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.concurrent.ConcurrentContext;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VirtualFile;

public class EeLogger_$logger
extends DelegatingBasicLogger
implements EeLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EeLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public EeLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cannotResolve(String elementName, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotResolve$str(), (Object)elementName, (Object)name);
    }

    protected String cannotResolve$str() {
        return "WFLYEE0002: Could not resolve %s %s";
    }

    @Override
    public final void componentDestroyFailure(Throwable cause, ComponentInstance component) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.componentDestroyFailure$str(), (Object)component);
    }

    protected String componentDestroyFailure$str() {
        return "WFLYEE0006: Failed to destroy component instance %s";
    }

    @Override
    public final void componentInstallationFailure(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.componentInstallationFailure$str(), (Object)name);
    }

    protected String componentInstallationFailure$str() {
        return "WFLYEE0007: Not installing optional component %s due to an exception (enable DEBUG log level to see the cause)";
    }

    @Override
    public final void invalidManagedBeanAbstractOrFinal(String sectionId, String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidManagedBeanAbstractOrFinal$str(), (Object)sectionId, (Object)className);
    }

    protected String invalidManagedBeanAbstractOrFinal$str() {
        return "WFLYEE0009: [Managed Bean spec, section %s] Managed bean implementation class MUST NOT be an interface - %s is an interface, hence won't be considered as a managed bean.";
    }

    @Override
    public final void invalidManagedBeanInterface(String sectionId, String className) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidManagedBeanInterface$str(), (Object)sectionId, (Object)className);
    }

    protected String invalidManagedBeanInterface$str() {
        return "WFLYEE0010: [Managed Bean spec, section %s] Managed bean implementation class MUST NOT be abstract or final - %s won't be considered as a managed bean, since it doesn't meet that requirement.";
    }

    @Override
    public final void preDestroyInterceptorFailure(Throwable cause, Class<?> component) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.preDestroyInterceptorFailure$str(), component);
    }

    protected String preDestroyInterceptorFailure$str() {
        return "WFLYEE0011: Exception while invoking pre-destroy interceptor for component class: %s";
    }

    @Override
    public final void subdeploymentIgnored(String pathName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.subdeploymentIgnored$str(), (Object)pathName);
    }

    protected String subdeploymentIgnored$str() {
        return "WFLYEE0014: %s in subdeployment ignored. jboss-ejb-client.xml is only parsed for top level deployments.";
    }

    protected String alternateDeploymentDescriptor$str() {
        return "WFLYEE0019: Could not find alternate deployment descriptor %s specified for %s";
    }

    @Override
    public final DeploymentUnitProcessingException alternateDeploymentDescriptor(VirtualFile deploymentDescriptor, VirtualFile moduleFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.alternateDeploymentDescriptor$str(), deploymentDescriptor, moduleFile));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String annotationAttributeMissing$str() {
        return "WFLYEE0020: %s annotations must provide a %s.";
    }

    @Override
    public final IllegalArgumentException annotationAttributeMissing(String annotation, String attribute) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.annotationAttributeMissing$str(), annotation, attribute));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddMoreItems$str() {
        return "WFLYEE0021: Cannot add any more items once getSortedItems() has been called";
    }

    @Override
    public final IllegalStateException cannotAddMoreItems() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotAddMoreItems$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotBeEmpty$str() {
        return "WFLYEE0022: %s may not be empty";
    }

    @Override
    public final RuntimeException cannotBeEmpty(String name) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotBeEmpty$str(), name));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotBeNullOrEmpty$str() {
        return "WFLYEE0023: %s cannot be null or empty: %s";
    }

    @Override
    public final IllegalArgumentException cannotBeNullOrEmpty(String name, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotBeNullOrEmpty$str(), name, value));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotConfigureComponent$str() {
        return "WFLYEE0024: Could not configure component %s";
    }

    @Override
    public final DeploymentUnitProcessingException cannotConfigureComponent(Throwable cause, String name) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotConfigureComponent$str(), name), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotDetermineType1$str() {
        return "WFLYEE0025: Could not determine type for resource-env-ref %s";
    }

    @Override
    public final DeploymentUnitProcessingException cannotDetermineType(String name) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotDetermineType1$str(), name));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotDetermineType3$str() {
        return "WFLYEE0026: Could not determine type for %s %s please specify the %s.";
    }

    @Override
    public final DeploymentUnitProcessingException cannotDetermineType(String tag, String value, String typeTag) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotDetermineType3$str(), tag, value, typeTag));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotLoad$str() {
        return "WFLYEE0027: Could not load %s referenced in env-entry";
    }

    @Override
    public final DeploymentUnitProcessingException cannotLoad(String injectionTarget) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotLoad$str(), injectionTarget));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final DeploymentUnitProcessingException cannotLoad(Throwable cause, String injectionTarget) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotLoad$str(), injectionTarget), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotLoadInterceptor1$str() {
        return "WFLYEE0028: Could not load interceptor class %s";
    }

    @Override
    public final RuntimeException cannotLoadInterceptor(Throwable cause, String className) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotLoadInterceptor1$str(), className), cause);
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotLoadInterceptor2$str() {
        return "WFLYEE0029: Could not load interceptor class %s on component %s";
    }

    @Override
    public final DeploymentUnitProcessingException cannotLoadInterceptor(Throwable cause, String className, Class<?> component) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotLoadInterceptor2$str(), className, component), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotLoadViewClass$str() {
        return "WFLYEE0030: Could not load view class %s for component %s";
    }

    @Override
    public final DeploymentUnitProcessingException cannotLoadViewClass(Throwable cause, String className, ComponentConfiguration component) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotLoadViewClass$str(), className, component), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotProcessEarModule$str() {
        return "WFLYEE0031: Unable to process modules in application.xml for EAR [%s], module file %s not found";
    }

    @Override
    public final DeploymentUnitProcessingException cannotProcessEarModule(VirtualFile earFile, String moduleFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotProcessEarModule$str(), earFile, moduleFile));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotParseResourceRefUri$str() {
        return "WFLYEE0032: Unable to parse resource-ref URI: %s";
    }

    @Override
    public final DeploymentUnitProcessingException cannotParseResourceRefUri(Throwable cause, String uri) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotParseResourceRefUri$str(), uri), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotResolveInjectionPoint$str() {
        return "WFLYEE0033: Could not resolve injection point %s on class %s specified in web.xml";
    }

    @Override
    public final DeploymentUnitProcessingException cannotResolveInjectionPoint(String targetName, String className) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotResolveInjectionPoint$str(), targetName, className));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotResolveMethod$str() {
        return "WFLYEE0034: Could not resolve method %s on class %s with annotations %s";
    }

    @Override
    public final RuntimeException cannotResolveMethod(MethodIdentifier method, Class<?> component, Collection<?> annotations) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotResolveMethod$str(), method, component, annotations));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSpecifyBoth$str() {
        return "WFLYEE0036: Cannot specify both a %s and a %s in an environment entry.";
    }

    @Override
    public final DeploymentUnitProcessingException cannotSpecifyBoth(String element1, String element2) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotSpecifyBoth$str(), element1, element2));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String circularDependency$str() {
        return "WFLYEE0037: Circular dependency installing %s";
    }

    @Override
    public final IllegalArgumentException circularDependency(String bindingName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.circularDependency$str(), bindingName));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String classOnlyAnnotation$str() {
        return "WFLYEE0038: %s annotation is only allowed on a class. %s is not a class.";
    }

    @Override
    public final DeploymentUnitProcessingException classOnlyAnnotation(String annotation, AnnotationTarget target) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.classOnlyAnnotation$str(), annotation, target));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String componentAlreadyDefined$str() {
        return "WFLYEE0040: A component named '%s' is already defined in this module";
    }

    @Override
    public final IllegalArgumentException componentAlreadyDefined(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.componentAlreadyDefined$str(), name));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentClassHasErrors$str() {
        return "WFLYEE0041: Component class %s for component %s has errors: %n%s";
    }

    @Override
    public final DeploymentUnitProcessingException componentClassHasErrors(String className, String componentName, String errorMsg) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.componentClassHasErrors$str(), className, componentName, errorMsg));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String componentConstructionFailure$str() {
        return "WFLYEE0042: Failed to construct component instance";
    }

    @Override
    public final IllegalStateException componentConstructionFailure(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.componentConstructionFailure$str(), new Object[0]), cause);
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentIsStopped$str() {
        return "WFLYEE0043: Component is stopped";
    }

    @Override
    public final ComponentIsStoppedException componentIsStopped() {
        ComponentIsStoppedException result = new ComponentIsStoppedException(String.format(this.getLoggingLocale(), this.componentIsStopped$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentNotAvailable$str() {
        return "WFLYEE0044: Component not available (interrupted)";
    }

    @Override
    public final IllegalStateException componentNotAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.componentNotAvailable$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String componentNotFound$str() {
        return "WFLYEE0045: No component found for type '%s'";
    }

    @Override
    public final DeploymentUnitProcessingException componentNotFound(String typeName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.componentNotFound$str(), typeName));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String componentViewConstructionFailure$str() {
        return "WFLYEE0046: Failed to instantiate component view";
    }

    @Override
    public final IllegalStateException componentViewConstructionFailure(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.componentViewConstructionFailure$str(), new Object[0]), cause);
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingBinding$str() {
        return "WFLYEE0047: Incompatible conflicting binding at %s source: %s";
    }

    @Override
    public final IllegalArgumentException conflictingBinding(String bindingName, InjectionSource source) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.conflictingBinding$str(), bindingName, source));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String defaultConstructorNotFound$str() {
        return "WFLYEE0048: Could not find default constructor for %s";
    }

    @Override
    public final DeploymentUnitProcessingException defaultConstructorNotFound(Class<?> clazz) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.defaultConstructorNotFound$str(), clazz));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String defaultConstructorNotFoundOnComponent$str() {
        return "WFLYEE0050: No default constructor for interceptor class %s on component %s";
    }

    @Override
    public final DeploymentUnitProcessingException defaultConstructorNotFoundOnComponent(String className, Class<?> component) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.defaultConstructorNotFoundOnComponent$str(), className, component));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String elementAttributeMissing$str() {
        return "WFLYEE0051: %s elements must provide a %s.";
    }

    @Override
    public final IllegalArgumentException elementAttributeMissing(String element, String attribute) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.elementAttributeMissing$str(), element, attribute));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToInstallComponent$str() {
        return "WFLYEE0052: Failed to install component %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToInstallComponent(Throwable cause, String name) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToInstallComponent$str(), name), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToParse$str() {
        return "WFLYEE0053: Failed to parse %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToParse(Throwable cause, VirtualFile xmlFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToParse$str(), xmlFile), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToProcessChild$str() {
        return "WFLYEE0054: Failed to process children for EAR [%s]";
    }

    @Override
    public final DeploymentUnitProcessingException failedToProcessChild(Throwable cause, VirtualFile earFile) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToProcessChild$str(), earFile), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToRead2$str() {
        return "WFLYEE0055: Failed to read %s entries for application [%s]";
    }

    @Override
    public final String failedToRead(String entryName, String appName) {
        return String.format(this.getLoggingLocale(), this.failedToRead2$str(), entryName, appName);
    }

    protected String failedToRead3$str() {
        return "WFLYEE0056: Failed to read %s entries for module [%s, %s]";
    }

    @Override
    public final String failedToRead(String entryName, String appName, String moduleName) {
        return String.format(this.getLoggingLocale(), this.failedToRead3$str(), entryName, appName, moduleName);
    }

    protected String failedToRead4$str() {
        return "WFLYEE0057: Failed to read %s entries for component [%s, %s, %s]";
    }

    @Override
    public final String failedToRead(String entryName, String appName, String moduleName, String componentName) {
        return String.format(this.getLoggingLocale(), this.failedToRead4$str(), entryName, appName, moduleName, componentName);
    }

    protected String fieldNotFound$str() {
        return "WFLYEE0058: No matching field found for '%s'";
    }

    @Override
    public final DeploymentUnitProcessingException fieldNotFound(String name) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.fieldNotFound$str(), name));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String injectionTargetNotFound$str() {
        return "WFLYEE0059: No injection target found";
    }

    @Override
    public final IllegalStateException injectionTargetNotFound() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.injectionTargetNotFound$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCharacterLength$str() {
        return "WFLYEE0060: %s of type java.lang.Character is not exactly one character long %s";
    }

    @Override
    public final DeploymentUnitProcessingException invalidCharacterLength(String elementName, String value) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidCharacterLength$str(), elementName, value));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidDescriptor$str() {
        return "WFLYEE0061: %s is not a valid descriptor";
    }

    @Override
    public final RuntimeException invalidDescriptor(String descriptor) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidDescriptor$str(), descriptor));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidInjectionTarget$str() {
        return "WFLYEE0062: Injection target %s on class %s is not compatible with the type of injection: %s";
    }

    @Override
    public final DeploymentUnitProcessingException invalidInjectionTarget(String targetName, String targetType, Class<?> type) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidInjectionTarget$str(), targetName, targetType, type));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidNumberOfArguments$str() {
        return "WFLYEE0063: Invalid number of arguments for method %s annotated with %s on class %s";
    }

    @Override
    public final String invalidNumberOfArguments(String methodName, DotName annotation, DotName className) {
        return String.format(this.getLoggingLocale(), this.invalidNumberOfArguments$str(), methodName, annotation, className);
    }

    protected String invalidReturnType$str() {
        return "WFLYEE0064: A return type of %s is required for method %s annotated with %s on class %s";
    }

    @Override
    public final IllegalArgumentException invalidReturnType(String returnType, String methodName, DotName annotation, DotName className) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidReturnType$str(), returnType, methodName, annotation, className));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSignature$str() {
        return "WFLYEE0065: Invalid signature for method %s annotated with %s on class %s, signature must be '%s'";
    }

    @Override
    public final String invalidSignature(String name, DotName annotation, DotName className, String signatureArg) {
        return String.format(this.getLoggingLocale(), this.invalidSignature$str(), name, annotation, className, signatureArg);
    }

    protected String invalidValue$str() {
        return "WFLYEE0066: Invalid value: %s for '%s' element";
    }

    @Override
    public final XMLStreamException invalidValue(String value, String element, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.invalidValue$str(), value, element), location);
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String methodNotFound1$str() {
        return "WFLYEE0067: Method does not exist %s";
    }

    @Override
    public final IllegalStateException methodNotFound(Method method) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.methodNotFound1$str(), method));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String methodNotFound3$str() {
        return "WFLYEE0068: No matching method found for method %s (%s) on %s";
    }

    @Override
    public final DeploymentUnitProcessingException methodNotFound(String name, String paramType, String className) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.methodNotFound3$str(), name, paramType, className));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String methodOnlyAnnotation$str() {
        return "WFLYEE0069: @%s is only valid on method targets.";
    }

    @Override
    public final DeploymentUnitProcessingException methodOnlyAnnotation(DotName annotation) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.methodOnlyAnnotation$str(), annotation));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleComponentsFound$str() {
        return "WFLYEE0070: Multiple components found for type '%s'";
    }

    @Override
    public final DeploymentUnitProcessingException multipleComponentsFound(String typeName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.multipleComponentsFound$str(), typeName));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleMethodsFound$str() {
        return "WFLYEE0071: More than one matching method found for method '%s (%s) on %s";
    }

    @Override
    public final DeploymentUnitProcessingException multipleMethodsFound(String name, String paramType, String className) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.multipleMethodsFound$str(), name, paramType, className));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleSetterMethodsFound$str() {
        return "WFLYEE0072: Multiple setter methods for %s on class %s found when applying <injection-target> for env-entry";
    }

    @Override
    public final DeploymentUnitProcessingException multipleSetterMethodsFound(String targetName, String className) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.multipleSetterMethodsFound$str(), targetName, className));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noComponentInstance$str() {
        return "WFLYEE0073: No component instance associated";
    }

    @Override
    public final IllegalStateException noComponentInstance() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noComponentInstance$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullBindingName$str() {
        return "WFLYEE0074: Binding name must not be null: %s";
    }

    @Override
    public final DeploymentUnitProcessingException nullBindingName(BindingConfiguration config) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.nullBindingName$str(), config));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nullOrEmptyManagedBeanClassName$str() {
        return "WFLYEE0075: Managed bean class name cannot be null or empty";
    }

    @Override
    public final IllegalArgumentException nullOrEmptyManagedBeanClassName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullOrEmptyManagedBeanClassName$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullOrEmptyResourceReferenceType$str() {
        return "WFLYEE0076: Resource reference type cannot be null or empty";
    }

    @Override
    public final IllegalArgumentException nullOrEmptyResourceReferenceType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullOrEmptyResourceReferenceType$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullResourceReference$str() {
        return "WFLYEE0077: Cannot register a null resource reference processor";
    }

    @Override
    public final IllegalArgumentException nullResourceReference() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullResourceReference$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullVar1$str() {
        return "WFLYEE0078: %s is null";
    }

    @Override
    public final IllegalArgumentException nullVar(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullVar1$str(), name));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String priorityAlreadyExists$str() {
        return "WFLYEE0079: Can't add %s, priority 0x%s is already taken by %s";
    }

    @Override
    public final IllegalArgumentException priorityAlreadyExists(Object item, String hexPriority, Object current) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.priorityAlreadyExists$str(), item, hexPriority, current));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serviceNotStarted$str() {
        return "WFLYEE0082: Service not started";
    }

    @Override
    public final IllegalStateException serviceNotStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceNotStarted$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String setterMethodOnly$str() {
        return "WFLYEE0083: %s injection target is invalid.  Only setter methods are allowed: %s";
    }

    @Override
    public final IllegalArgumentException setterMethodOnly(String annotation, MethodInfo methodInfo) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.setterMethodOnly$str(), annotation, methodInfo));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAnnotationTargetType$str() {
        return "WFLYEE0084: Unknown AnnotationTarget type: %s";
    }

    @Override
    public final RuntimeException unknownAnnotationTargetType(AnnotationTarget target) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unknownAnnotationTargetType$str(), target));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownElementType$str() {
        return "WFLYEE0085: Unknown %s type %s";
    }

    @Override
    public final DeploymentUnitProcessingException unknownElementType(String elementName, String type) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.unknownElementType$str(), elementName, type));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String viewMethodNotFound$str() {
        return "WFLYEE0086: Could not find method %s %s on view %s of %s";
    }

    @Override
    public final IllegalArgumentException viewMethodNotFound(String name, String descriptor, Class<?> viewClass, Class<?> component) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.viewMethodNotFound$str(), name, descriptor, viewClass, component));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedElement$str() {
        return "WFLYEE0088: Unexpected element '%s' encountered";
    }

    @Override
    public final XMLStreamException unexpectedElement(QName name, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unexpectedElement$str(), name), location);
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToProcessEJBClientDescriptor$str() {
        return "WFLYEE0089: Failed to process jboss-ejb-client.xml";
    }

    @Override
    public final DeploymentUnitProcessingException failedToProcessEJBClientDescriptor(Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToProcessEJBClientDescriptor$str(), new Object[0]), cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String xmlErrorParsingEJBClientDescriptor$str() {
        return "WFLYEE0090: Exception while parsing jboss-ejb-client.xml file found at %s";
    }

    @Override
    public final DeploymentUnitProcessingException xmlErrorParsingEJBClientDescriptor(XMLStreamException cause, String fileLocation) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.xmlErrorParsingEJBClientDescriptor$str(), fileLocation), (Throwable)cause);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorParsingEJBClientDescriptor$str() {
        return "WFLYEE0091: %s";
    }

    @Override
    public final XMLStreamException errorParsingEJBClientDescriptor(String message, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.errorParsingEJBClientDescriptor$str(), message), location);
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noMessageDestination$str() {
        return "WFLYEE0092: No message destination with name %s for binding %s";
    }

    @Override
    public final String noMessageDestination(String name, String binding) {
        return String.format(this.getLoggingLocale(), this.noMessageDestination$str(), name, binding);
    }

    protected String moreThanOneMessageDestination$str() {
        return "WFLYEE0093: More than one message destination with name %s for binding %s destinations: %s";
    }

    @Override
    public final String moreThanOneMessageDestination(String name, String binding, Set<String> jndiNames) {
        return String.format(this.getLoggingLocale(), this.moreThanOneMessageDestination$str(), name, binding, jndiNames);
    }

    protected String failedToLoadJbossProperties$str() {
        return "WFLYEE0094: Failed to load jboss.properties";
    }

    @Override
    public final DeploymentUnitProcessingException failedToLoadJbossProperties(IOException e) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToLoadJbossProperties$str(), new Object[0]), (Throwable)e);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedModuleType$str() {
        return "WFLYEE0095: Unsupported ear module type: %s";
    }

    @Override
    public final DeploymentUnitProcessingException unsupportedModuleType(String moduleFileName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.unsupportedModuleType$str(), moduleFileName));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String rootAsLibraryDirectory$str() {
        return "WFLYEE0096: library-directory of value / is not supported";
    }

    @Override
    public final DeploymentUnitProcessingException rootAsLibraryDirectory() {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.rootAsLibraryDirectory$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String earModuleChildOfLibraryDirectory$str() {
        return "WFLYEE0097: Module may not be a child of the EAR's library directory. Library directory: %s, module file name: %s";
    }

    @Override
    public final DeploymentUnitProcessingException earModuleChildOfLibraryDirectory(String libraryDirectory, String moduleFileName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.earModuleChildOfLibraryDirectory$str(), libraryDirectory, moduleFileName));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String managedReferenceWasNull$str() {
        return "WFLYEE0098: ManagedReference was null and injection is not optional for injection into field %s";
    }

    @Override
    public final RuntimeException managedReferenceWasNull(Field field) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.managedReferenceWasNull$str(), field));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String propertiesNotAllowedOnGlobalModules$str() {
        return "WFLYEE0100: Global modules may not specify 'annotations', 'meta-inf' or 'services'.";
    }

    @Override
    public final String propertiesNotAllowedOnGlobalModules() {
        return String.format(this.getLoggingLocale(), this.propertiesNotAllowedOnGlobalModules$str(), new Object[0]);
    }

    protected String concurrentServiceValueUninitialized$str() {
        return "WFLYEE0102: EE Concurrent Service's value uninitialized.";
    }

    @Override
    public final IllegalStateException concurrentServiceValueUninitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.concurrentServiceValueUninitialized$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serializationMustBeHandledByTheFactory$str() {
        return "WFLYEE0103: EE Concurrent ContextHandle serialization must be handled by the factory.";
    }

    @Override
    public final IOException serializationMustBeHandledByTheFactory() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.serializationMustBeHandledByTheFactory$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String factoryAlreadyExists$str() {
        return "WFLYEE0104: The EE Concurrent Context %s already has a factory named %s";
    }

    @Override
    public final IllegalArgumentException factoryAlreadyExists(ConcurrentContext concurrentContext, String factoryName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.factoryAlreadyExists$str(), concurrentContext, factoryName));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String factoryNotFound$str() {
        return "WFLYEE0105: EE Concurrent Context %s does not has a factory named %s";
    }

    @Override
    public final IOException factoryNotFound(ConcurrentContext concurrentContext, String factoryName) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.factoryNotFound$str(), concurrentContext, factoryName));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String concurrentContextServiceNotInstalled$str() {
        return "WFLYEE0106: EE Concurrent Context %s service not installed.";
    }

    @Override
    public final IOException concurrentContextServiceNotInstalled(ServiceName serviceName) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.concurrentContextServiceNotInstalled$str(), serviceName));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionSetupProviderServiceNotInstalled$str() {
        return "WFLYEE0107: EE Concurrent Transaction Setup Provider service not installed.";
    }

    @Override
    public final IllegalStateException transactionSetupProviderServiceNotInstalled() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.transactionSetupProviderServiceNotInstalled$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String instanceDataCanOnlyBeSetDuringConstruction$str() {
        return "WFLYEE0108: Instance data can only be set during construction";
    }

    @Override
    public final IllegalStateException instanceDataCanOnlyBeSetDuringConstruction() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.instanceDataCanOnlyBeSetDuringConstruction$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String aroundInvokeAnnotationUsedTooManyTimes$str() {
        return "WFLYEE0109: A class must not declare more than one AroundInvoke method. %s has %s methods annotated.";
    }

    @Override
    public final DeploymentUnitProcessingException aroundInvokeAnnotationUsedTooManyTimes(DotName className, int numberOfAnnotatedMethods) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.aroundInvokeAnnotationUsedTooManyTimes$str(), className, numberOfAnnotatedMethods));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void failedToRunTask(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToRunTask$str(), new Object[0]);
    }

    protected String failedToRunTask$str() {
        return "WFLYEE0110: Failed to run scheduled task";
    }

    protected String cannotRunScheduledTask$str() {
        return "WFLYEE0111: Cannot run scheduled task %s as container is suspended";
    }

    @Override
    public final IllegalStateException cannotRunScheduledTask(Object delegate) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotRunScheduledTask$str(), delegate));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCoreThreadsSize$str() {
        return "WFLYEE0112: The core-threads value must be greater than 0 when the queue-length is %s";
    }

    @Override
    public final OperationFailedException invalidCoreThreadsSize(String queueLengthValue) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidCoreThreadsSize$str(), queueLengthValue));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidMaxThreads$str() {
        return "WFLYEE0113: The max-threads value %d cannot be less than the core-threads value %d.";
    }

    @Override
    public final OperationFailedException invalidMaxThreads(int maxThreads, int coreThreads) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidMaxThreads$str(), maxThreads, coreThreads));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String classDoesNotImplementAllInterfaces$str() {
        return "WFLYEE0114: Class does not implement all of the provided interfaces";
    }

    @Override
    public final IllegalArgumentException classDoesNotImplementAllInterfaces() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.classDoesNotImplementAllInterfaces$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullName$str() {
        return "WFLYEE0115: The name of the %s is null";
    }

    @Override
    public final IllegalArgumentException nullName(String objectType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullName$str(), objectType));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullVar3$str() {
        return "WFLYEE0116: %s is null in the %s %s";
    }

    @Override
    public final IllegalArgumentException nullVar(String variable, String objectType, String objectName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullVar3$str(), variable, objectType, objectName));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSetField$str() {
        return "WFLYEE0117: Field %s cannot be set - object of %s loaded by %s is not assignable to %s loaded by %s";
    }

    @Override
    public final IllegalArgumentException cannotSetField(String fieldName, Class<?> injectedClass, ClassLoader injectedClassloader, Class<?> fieldClass, ClassLoader fieldClassloader) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotSetField$str(), fieldName, injectedClass, injectedClassloader, fieldClass, fieldClassloader));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String executorServiceNotFound$str() {
        return "WFLYEE0120: Failed to locate executor service '%s'";
    }

    @Override
    public final OperationFailedException executorServiceNotFound(ServiceName serviceName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.executorServiceNotFound$str(), serviceName));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedExecutorServiceMetric$str() {
        return "WFLYEE0121: Unsupported attribute '%s'";
    }

    @Override
    public final IllegalStateException unsupportedExecutorServiceMetric(String attributeName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unsupportedExecutorServiceMetric$str(), attributeName));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String globalDirectoryDoNotExist$str() {
        return "WFLYEE0122: Directory path %s in %s global-directory resource does not point to a valid directory.";
    }

    @Override
    public final StartException globalDirectoryDoNotExist(String globalDirectoryPath, String globalDirectoryName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.globalDirectoryDoNotExist$str(), globalDirectoryPath, globalDirectoryName));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String oneGlobalDirectory$str() {
        return "WFLYEE0123: Global directory %s cannot be added, because global directory %s is already defined.";
    }

    @Override
    public final OperationFailedException oneGlobalDirectory(String newGlobalDirectory, String existingGlobalDirectory) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.oneGlobalDirectory$str(), newGlobalDirectory, existingGlobalDirectory));
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void errorDeletingJACCPolicy(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.errorDeletingJACCPolicy$str(), new Object[0]);
    }

    protected String errorDeletingJACCPolicy$str() {
        return "WFLYEE0124: Error deleting Jakarta Authorization Policy";
    }

    protected String unableToStartException$str() {
        return "WFLYEE0125: Unable to start the %s service";
    }

    @Override
    public final StartException unableToStartException(String service, Throwable t) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.unableToStartException$str(), service), t);
        EeLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String rejectedDueToMaxRequests$str() {
        return "WFLYEE0126: Rejected due to maximum number of requests";
    }

    @Override
    public final RejectedExecutionException rejectedDueToMaxRequests() {
        RejectedExecutionException result = new RejectedExecutionException(String.format(this.getLoggingLocale(), this.rejectedDueToMaxRequests$str(), new Object[0]));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void invalidNamePrefix(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidNamePrefix$str(), (Object)name);
    }

    protected String invalidNamePrefix$str() {
        return "WFLYEE0127: Invalid '%s' name segment for env, name can't start with '/' prefix, prefix has been removed";
    }

    @Override
    public final void huntTaskTerminationFailure(Throwable cause, String executorName, String taskName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.huntTaskTerminationFailure$str(), (Object)executorName, (Object)taskName);
    }

    protected String huntTaskTerminationFailure$str() {
        return "WFLYEE0128: Failure when terminating %s hung task %s";
    }

    @Override
    public final void hungTaskCancelled(String executorName, String taskName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.hungTaskCancelled$str(), (Object)executorName, (Object)taskName);
    }

    protected String hungTaskCancelled$str() {
        return "WFLYEE0129: %s hung task %s cancelled";
    }

    @Override
    public final void hungTaskNotCancelled(String executorName, String taskName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.hungTaskNotCancelled$str(), (Object)executorName, (Object)taskName);
    }

    protected String hungTaskNotCancelled$str() {
        return "WFLYEE0130: %s hung task %s not cancelled";
    }

    protected String attributeNoLongerSupported$str() {
        return "WFLYEE0131: The attribute %s is no longer supported.";
    }

    @Override
    public final XMLStreamException attributeNoLongerSupported(String attribute) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.attributeNoLongerSupported$str(), attribute));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String managedReferenceMethodWasNull$str() {
        return "WFLYEE0132: ManagedReference was null and injection is not optional for injection into method %s";
    }

    @Override
    public final RuntimeException managedReferenceMethodWasNull(Method method) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.managedReferenceMethodWasNull$str(), method));
        EeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

