/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;
import org.jboss.as.ee.concurrent.IdentityAwareProxyInvocationHandler;
import org.jboss.as.ee.logging.EeLogger;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ContextServiceImpl
extends org.glassfish.enterprise.concurrent.ContextServiceImpl {
    public ContextServiceImpl(String name, ContextSetupProvider contextSetupProvider, TransactionSetupProvider transactionSetupProvider) {
        super(name, contextSetupProvider, transactionSetupProvider);
    }

    private <T> T internalCreateContextualProxy(T instance, Map<String, String> executionProperties, Class<T> intf) {
        Assert.checkNotNullParam((String)"instance", instance);
        Assert.checkNotNullParam((String)"intf", intf);
        IdentityAwareProxyInvocationHandler handler = new IdentityAwareProxyInvocationHandler(this, instance, executionProperties);
        Object proxy = Proxy.newProxyInstance(instance.getClass().getClassLoader(), new Class[]{intf}, (InvocationHandler)((Object)handler));
        return intf.cast(proxy);
    }

    public <T> T createContextualProxy(final T instance, final Map<String, String> executionProperties, final Class<T> intf) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return ContextServiceImpl.this.internalCreateContextualProxy(instance, (Map<String, String>)executionProperties, intf);
                }
            });
        }
        return this.internalCreateContextualProxy(instance, executionProperties, intf);
    }

    private Object internalCreateContextualProxy(Object instance, Map<String, String> executionProperties, Class<?> ... interfaces) {
        Assert.checkNotNullParam((String)"instance", (Object)instance);
        Assert.checkArrayBounds((Object[])((Object[])Assert.checkNotNullParam((String)"interfaces", interfaces)), (int)0, (int)1);
        Class<?> instanceClass = instance.getClass();
        for (Class<?> thisInterface : interfaces) {
            if (thisInterface.isAssignableFrom(instanceClass)) continue;
            throw EeLogger.ROOT_LOGGER.classDoesNotImplementAllInterfaces();
        }
        IdentityAwareProxyInvocationHandler handler = new IdentityAwareProxyInvocationHandler(this, instance, executionProperties);
        Object proxy = Proxy.newProxyInstance(instance.getClass().getClassLoader(), interfaces, (InvocationHandler)((Object)handler));
        return proxy;
    }

    public Object createContextualProxy(final Object instance, final Map<String, String> executionProperties, final Class<?> ... interfaces) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return ContextServiceImpl.this.internalCreateContextualProxy(instance, (Map<String, String>)executionProperties, interfaces);
                }
            });
        }
        return this.internalCreateContextualProxy(instance, executionProperties, interfaces);
    }
}

