/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;
import org.jboss.as.ee.logging.EeLogger;

public class EEResourceReferenceProcessorRegistry {
    private final Map<String, EEResourceReferenceProcessor> resourceReferenceProcessors = new ConcurrentHashMap<String, EEResourceReferenceProcessor>();

    public void registerResourceReferenceProcessor(EEResourceReferenceProcessor resourceReferenceProcessor) {
        if (resourceReferenceProcessor == null) {
            throw EeLogger.ROOT_LOGGER.nullResourceReference();
        }
        String resourceReferenceType = resourceReferenceProcessor.getResourceReferenceType();
        if (resourceReferenceType == null || resourceReferenceType.trim().isEmpty()) {
            throw EeLogger.ROOT_LOGGER.nullOrEmptyResourceReferenceType();
        }
        this.resourceReferenceProcessors.put(resourceReferenceType, resourceReferenceProcessor);
    }

    public EEResourceReferenceProcessor getResourceReferenceProcessor(String resourceReferenceType) {
        return this.resourceReferenceProcessors.get(resourceReferenceType);
    }
}

