/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.service;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceAdapter;
import org.jboss.as.ee.concurrent.ManagedExecutorServiceImpl;
import org.jboss.as.ee.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.service.EEConcurrentAbstractService;
import org.jboss.as.ee.concurrent.service.ManagedExecutorHungTasksPeriodicTerminationService;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RequestController;

public class ManagedExecutorServiceService
extends EEConcurrentAbstractService<ManagedExecutorServiceAdapter> {
    private volatile ManagedExecutorServiceImpl executorService;
    private final String name;
    private final InjectedValue<ManagedThreadFactoryImpl> managedThreadFactoryInjectedValue;
    private final long hungTaskThreshold;
    private final long hungTaskTerminationPeriod;
    private final boolean longRunningTasks;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final long keepAliveTime;
    private final TimeUnit keepAliveTimeUnit;
    private final long threadLifeTime;
    private final int queueCapacity;
    private final InjectedValue<ContextServiceImpl> contextService = new InjectedValue();
    private final AbstractManagedExecutorService.RejectPolicy rejectPolicy;
    private final Integer threadPriority;
    private final InjectedValue<RequestController> requestController = new InjectedValue();
    private ControlPoint controlPoint;
    private final Supplier<ManagedExecutorHungTasksPeriodicTerminationService> hungTasksPeriodicTerminationService;
    private Future hungTasksPeriodicTerminationFuture;

    public ManagedExecutorServiceService(String name, String jndiName, long hungTaskThreshold, long hungTaskTerminationPeriod, boolean longRunningTasks, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, int queueCapacity, AbstractManagedExecutorService.RejectPolicy rejectPolicy, Integer threadPriority, Supplier<ManagedExecutorHungTasksPeriodicTerminationService> hungTasksPeriodicTerminationService) {
        super(jndiName);
        this.name = name;
        this.managedThreadFactoryInjectedValue = new InjectedValue();
        this.hungTaskThreshold = hungTaskThreshold;
        this.hungTaskTerminationPeriod = hungTaskTerminationPeriod;
        this.longRunningTasks = longRunningTasks;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeUnit = keepAliveTimeUnit;
        this.threadLifeTime = threadLifeTime;
        this.queueCapacity = queueCapacity;
        this.rejectPolicy = rejectPolicy;
        this.threadPriority = threadPriority;
        this.hungTasksPeriodicTerminationService = hungTasksPeriodicTerminationService;
    }

    @Override
    void startValue(StartContext context) throws StartException {
        ManagedThreadFactoryImpl managedThreadFactory;
        int priority = this.threadPriority != null ? this.threadPriority : ((managedThreadFactory = (ManagedThreadFactoryImpl)((Object)this.managedThreadFactoryInjectedValue.getOptionalValue())) != null ? managedThreadFactory.getPriority() : 5);
        managedThreadFactory = new ManagedThreadFactoryImpl("EE-ManagedExecutorService-" + this.name, null, priority);
        if (this.requestController.getOptionalValue() != null) {
            this.controlPoint = ((RequestController)this.requestController.getValue()).getControlPoint(this.name, "managed-executor-service");
        }
        this.executorService = new ManagedExecutorServiceImpl(this.name, (org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl)managedThreadFactory, this.hungTaskThreshold, this.longRunningTasks, this.corePoolSize, this.maxPoolSize, this.keepAliveTime, this.keepAliveTimeUnit, this.threadLifeTime, this.queueCapacity, (ContextServiceImpl)this.contextService.getOptionalValue(), this.rejectPolicy, this.controlPoint);
        if (this.hungTaskThreshold > 0L && this.hungTaskTerminationPeriod > 0L) {
            this.hungTasksPeriodicTerminationFuture = this.hungTasksPeriodicTerminationService.get().startHungTaskPeriodicTermination(this.executorService, this.hungTaskTerminationPeriod);
        }
    }

    @Override
    void stopValue(StopContext context) {
        if (this.executorService != null) {
            if (this.hungTasksPeriodicTerminationFuture != null) {
                this.hungTasksPeriodicTerminationFuture.cancel(true);
            }
            this.executorService.shutdownNow();
            this.executorService.getManagedThreadFactory().stop();
            this.executorService = null;
        }
        if (this.controlPoint != null) {
            ((RequestController)this.requestController.getValue()).removeControlPoint(this.controlPoint);
        }
    }

    public ManagedExecutorServiceAdapter getValue() throws IllegalStateException {
        return this.getExecutorService().getAdapter();
    }

    public ManagedExecutorServiceImpl getExecutorService() throws IllegalStateException {
        if (this.executorService == null) {
            throw EeLogger.ROOT_LOGGER.concurrentServiceValueUninitialized();
        }
        return this.executorService;
    }

    public Injector<ManagedThreadFactoryImpl> getManagedThreadFactoryInjector() {
        return this.managedThreadFactoryInjectedValue;
    }

    public Injector<ContextServiceImpl> getContextServiceInjector() {
        return this.contextService;
    }

    public InjectedValue<RequestController> getRequestController() {
        return this.requestController;
    }
}

