/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.resource.definition;

import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.ee.structure.EJBAnnotationPropertyReplacement;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.property.PropertyReplacer;

public abstract class ResourceDefinitionAnnotationProcessor
implements DeploymentUnitProcessor {
    protected abstract DotName getAnnotationDotName();

    protected abstract DotName getAnnotationCollectionDotName();

    protected abstract ResourceDefinitionInjectionSource processAnnotation(AnnotationInstance var1, PropertyReplacer var2) throws DeploymentUnitProcessingException;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            return;
        }
        PropertyReplacer propertyReplacer = EJBAnnotationPropertyReplacement.propertyReplacer(deploymentUnit);
        DotName annotationName = this.getAnnotationDotName();
        for (AnnotationInstance annotationInstance : index.getAnnotations(annotationName)) {
            List<BindingConfiguration> bindingConfigurations = this.getAnnotatedClassBindingConfigurations(moduleDescription, annotationInstance);
            ResourceDefinitionInjectionSource injectionSource = this.processAnnotation(annotationInstance, propertyReplacer);
            bindingConfigurations.add(new BindingConfiguration(injectionSource.getJndiName(), injectionSource));
        }
        DotName collectionAnnotationName = this.getAnnotationCollectionDotName();
        if (collectionAnnotationName != null) {
            for (AnnotationInstance annotationInstance : index.getAnnotations(collectionAnnotationName)) {
                AnnotationInstance[] nestedAnnotationInstances = annotationInstance.value().asNestedArray();
                if (nestedAnnotationInstances == null || nestedAnnotationInstances.length <= 0) continue;
                List<BindingConfiguration> bindingConfigurations = this.getAnnotatedClassBindingConfigurations(moduleDescription, annotationInstance);
                for (AnnotationInstance nestedAnnotationInstance : nestedAnnotationInstances) {
                    ResourceDefinitionInjectionSource injectionSource = this.processAnnotation(nestedAnnotationInstance, propertyReplacer);
                    bindingConfigurations.add(new BindingConfiguration(injectionSource.getJndiName(), injectionSource));
                }
            }
        }
    }

    private List<BindingConfiguration> getAnnotatedClassBindingConfigurations(EEModuleDescription moduleDescription, AnnotationInstance annotationInstance) throws DeploymentUnitProcessingException {
        AnnotationTarget target = annotationInstance.target();
        if (!(target instanceof ClassInfo)) {
            throw EeLogger.ROOT_LOGGER.classOnlyAnnotation(annotationInstance.toString(), target);
        }
        ClassInfo classInfo = (ClassInfo)target;
        return moduleDescription.addOrGetLocalClassDescription(classInfo.name().toString()).getBindingConfigurations();
    }

    public static class AnnotationElement {
        public static final String NAME = "name";
        public static final String PROPERTIES = "properties";

        public static boolean asOptionalBoolean(AnnotationInstance annotation, String property) {
            AnnotationValue value = annotation.value(property);
            return value == null ? true : value.asBoolean();
        }

        public static int asOptionalInt(AnnotationInstance annotation, String string) {
            AnnotationValue value = annotation.value(string);
            return value == null ? -1 : value.asInt();
        }

        public static int asOptionalInt(AnnotationInstance annotation, String property, int defaultValue) {
            AnnotationValue value = annotation.value(property);
            return value == null ? defaultValue : value.asInt();
        }

        public static String asOptionalString(AnnotationInstance annotation, String property) {
            return AnnotationElement.asOptionalString(annotation, property, "", null);
        }

        public static String asOptionalString(AnnotationInstance annotation, String property, String defaultValue) {
            return AnnotationElement.asOptionalString(annotation, property, defaultValue, null);
        }

        public static String asOptionalString(AnnotationInstance annotation, String property, PropertyReplacer propertyReplacer) {
            return AnnotationElement.asOptionalString(annotation, property, "", propertyReplacer);
        }

        public static String asOptionalString(AnnotationInstance annotation, String property, String defaultValue, PropertyReplacer propertyReplacer) {
            AnnotationValue value = annotation.value(property);
            if (value == null) {
                return defaultValue;
            }
            String valueString = value.asString();
            if (valueString.isEmpty()) {
                return defaultValue;
            }
            return propertyReplacer != null ? propertyReplacer.replaceProperties(valueString) : valueString;
        }

        public static String[] asOptionalStringArray(AnnotationInstance annotation, String property) {
            AnnotationValue value = annotation.value(property);
            return value == null ? new String[]{} : value.asStringArray();
        }

        public static String asRequiredString(AnnotationInstance annotationInstance, String attributeName) {
            return AnnotationElement.asRequiredString(annotationInstance, attributeName, null);
        }

        public static String asRequiredString(AnnotationInstance annotationInstance, String attributeName, PropertyReplacer propertyReplacer) {
            AnnotationValue nameValue = annotationInstance.value(attributeName);
            if (nameValue == null) {
                throw EeLogger.ROOT_LOGGER.annotationAttributeMissing(annotationInstance.name().toString(), attributeName);
            }
            String nameValueAsString = nameValue.asString();
            if (nameValueAsString.isEmpty()) {
                throw EeLogger.ROOT_LOGGER.annotationAttributeMissing(annotationInstance.name().toString(), attributeName);
            }
            return propertyReplacer != null ? propertyReplacer.replaceProperties(nameValueAsString) : nameValueAsString;
        }
    }
}

