/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.vfs.VirtualFile;

public class EEApplicationDescription {
    private final Map<String, List<ViewInformation>> componentsByViewName = new HashMap<String, List<ViewInformation>>();
    private final Map<String, List<Description>> componentsByName = new HashMap<String, List<Description>>();
    private final Map<String, List<MessageDestinationMapping>> messageDestinationJndiMapping = new HashMap<String, List<MessageDestinationMapping>>();

    public void addComponent(ComponentDescription description, VirtualFile deploymentRoot) {
        for (ViewDescription viewDescription : description.getViews()) {
            List<ViewInformation> viewComponents = this.componentsByViewName.get(viewDescription.getViewClassName());
            if (viewComponents == null) {
                viewComponents = new ArrayList<ViewInformation>(1);
                this.componentsByViewName.put(viewDescription.getViewClassName(), viewComponents);
            }
            viewComponents.add(new ViewInformation(viewDescription, deploymentRoot, description.getComponentName()));
        }
        List<Description> components = this.componentsByName.get(description.getComponentName());
        if (components == null) {
            components = new ArrayList<Description>(1);
            this.componentsByName.put(description.getComponentName(), components);
        }
        components.add(new Description(description, deploymentRoot));
    }

    public void addMessageDestination(String name, String resolvedName, VirtualFile deploymentRoot) {
        List<MessageDestinationMapping> components = this.messageDestinationJndiMapping.get(name);
        if (components == null) {
            components = new ArrayList<MessageDestinationMapping>(1);
            this.messageDestinationJndiMapping.put(name, components);
        }
        components.add(new MessageDestinationMapping(resolvedName, deploymentRoot));
    }

    public Set<ViewDescription> getComponentsForViewName(String viewType, VirtualFile deploymentRoot) {
        List<ViewInformation> info = this.componentsByViewName.get(viewType);
        if (info == null) {
            return Collections.emptySet();
        }
        HashSet<ViewDescription> ret = new HashSet<ViewDescription>();
        HashSet<ViewDescription> currentDep = new HashSet<ViewDescription>();
        for (ViewInformation i : info) {
            if (deploymentRoot.equals(i.deploymentRoot)) {
                currentDep.add(i.viewDescription);
            }
            ret.add(i.viewDescription);
        }
        if (!currentDep.isEmpty()) {
            return currentDep;
        }
        return ret;
    }

    public Set<ComponentDescription> getComponents(String componentName, VirtualFile deploymentRoot) {
        if (componentName.contains("#")) {
            String[] parts = componentName.split("#");
            Object path = parts[0];
            if (!((String)path).startsWith("../")) {
                path = "../" + (String)path;
            }
            VirtualFile virtualPath = deploymentRoot.getChild((String)path);
            String name = parts[1];
            List<Description> info = this.componentsByName.get(name);
            if (info == null) {
                return Collections.emptySet();
            }
            HashSet<ComponentDescription> ret = new HashSet<ComponentDescription>();
            for (Description i : info) {
                if (!virtualPath.equals(i.deploymentRoot)) continue;
                ret.add(i.componentDescription);
            }
            return ret;
        }
        List<Description> info = this.componentsByName.get(componentName);
        if (info == null) {
            return Collections.emptySet();
        }
        HashSet<ComponentDescription> all = new HashSet<ComponentDescription>();
        HashSet<ComponentDescription> thisDeployment = new HashSet<ComponentDescription>();
        for (Description i : info) {
            all.add(i.componentDescription);
            if (!i.deploymentRoot.equals(deploymentRoot)) continue;
            thisDeployment.add(i.componentDescription);
        }
        if (all.size() > 1) {
            return thisDeployment;
        }
        return all;
    }

    public Set<ViewDescription> getComponents(String componentName, String viewName, VirtualFile deploymentRoot) {
        List<ViewInformation> info = this.componentsByViewName.get(viewName);
        if (info == null) {
            return Collections.emptySet();
        }
        if (componentName.contains("#")) {
            String[] parts = componentName.split("#");
            Object path = parts[0];
            if (!((String)path).startsWith("../")) {
                path = "../" + (String)path;
            }
            VirtualFile virtualPath = deploymentRoot.getChild((String)path);
            String name = parts[1];
            HashSet<ViewDescription> ret = new HashSet<ViewDescription>();
            for (ViewInformation i : info) {
                if (!i.beanName.equals(name) || !virtualPath.equals(i.deploymentRoot)) continue;
                ret.add(i.viewDescription);
            }
            return ret;
        }
        HashSet<ViewDescription> all = new HashSet<ViewDescription>();
        HashSet<ViewDescription> thisDeployment = new HashSet<ViewDescription>();
        for (ViewInformation i : info) {
            if (!i.beanName.equals(componentName)) continue;
            all.add(i.viewDescription);
            if (!i.deploymentRoot.equals(deploymentRoot)) continue;
            thisDeployment.add(i.viewDescription);
        }
        if (all.size() > 1) {
            return thisDeployment;
        }
        return all;
    }

    public Set<String> resolveMessageDestination(String messageDestName, VirtualFile deploymentRoot) {
        if (messageDestName.contains("#")) {
            String[] parts = messageDestName.split("#");
            Object path = parts[0];
            if (!((String)path).startsWith("../")) {
                path = "../" + (String)path;
            }
            VirtualFile virtualPath = deploymentRoot.getChild((String)path);
            String name = parts[1];
            HashSet<String> ret = new HashSet<String>();
            List<MessageDestinationMapping> data = this.messageDestinationJndiMapping.get(name);
            if (data != null) {
                for (MessageDestinationMapping i : data) {
                    if (!virtualPath.equals(i.deploymentRoot)) continue;
                    ret.add(i.jndiName);
                }
            }
            return ret;
        }
        HashSet<String> all = new HashSet<String>();
        HashSet<String> thisDeployment = new HashSet<String>();
        List<MessageDestinationMapping> data = this.messageDestinationJndiMapping.get(messageDestName);
        if (data != null) {
            for (MessageDestinationMapping i : data) {
                all.add(i.jndiName);
                if (!i.deploymentRoot.equals(deploymentRoot)) continue;
                thisDeployment.add(i.jndiName);
            }
        }
        if (all.size() > 1) {
            return thisDeployment;
        }
        return all;
    }

    private static class ViewInformation {
        private final ViewDescription viewDescription;
        private final VirtualFile deploymentRoot;
        private final String beanName;

        ViewInformation(ViewDescription viewDescription, VirtualFile deploymentRoot, String beanName) {
            this.viewDescription = viewDescription;
            this.deploymentRoot = deploymentRoot;
            this.beanName = beanName;
        }
    }

    private static class Description {
        private final ComponentDescription componentDescription;
        private final VirtualFile deploymentRoot;

        Description(ComponentDescription componentDescription, VirtualFile deploymentRoot) {
            this.componentDescription = componentDescription;
            this.deploymentRoot = deploymentRoot;
        }
    }

    private static final class MessageDestinationMapping {
        private final String jndiName;
        private final VirtualFile deploymentRoot;

        MessageDestinationMapping(String jndiName, VirtualFile deploymentRoot) {
            this.jndiName = jndiName;
            this.deploymentRoot = deploymentRoot;
        }
    }
}

