/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.Timer;
import javax.ejb.TimerService;

public class TimerServiceRegistry {
    private final Set<TimerService> timerServices = Collections.synchronizedSet(new HashSet());

    public void registerTimerService(TimerService timerService) {
        if (timerService == null) {
            return;
        }
        this.timerServices.add(timerService);
    }

    public boolean unRegisterTimerService(TimerService timerService) {
        if (timerService == null) {
            return false;
        }
        return this.timerServices.remove(timerService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Timer> getAllActiveTimers() {
        HashSet<Timer> activeTimers = new HashSet<Timer>();
        Set<TimerService> set = this.timerServices;
        synchronized (set) {
            for (TimerService timerService : this.timerServices) {
                activeTimers.addAll(timerService.getTimers());
            }
        }
        return activeTimers;
    }
}

