/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.jboss.as.ejb3.iiop.handle.SerializationHackProxy;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ObjectImpl;

public class HandleDelegateImpl
implements HandleDelegate {
    private final SerializationHackProxy proxy;

    public HandleDelegateImpl(ClassLoader classLoader) {
        this.proxy = SerializationHackProxy.proxy(classLoader);
    }

    public void writeEJBObject(EJBObject ejbObject, ObjectOutputStream oostream) throws IOException {
        oostream.writeObject(ejbObject);
    }

    public EJBObject readEJBObject(ObjectInputStream oistream) throws IOException, ClassNotFoundException {
        Object ejbObject = this.proxy.read(oistream);
        this.reconnect(ejbObject);
        return (EJBObject)PortableRemoteObject.narrow((Object)ejbObject, EJBObject.class);
    }

    public void writeEJBHome(EJBHome ejbHome, ObjectOutputStream oostream) throws IOException {
        oostream.writeObject(ejbHome);
    }

    public EJBHome readEJBHome(ObjectInputStream oistream) throws IOException, ClassNotFoundException {
        Object ejbHome = this.proxy.read(oistream);
        this.reconnect(ejbHome);
        return (EJBHome)PortableRemoteObject.narrow((Object)ejbHome, EJBHome.class);
    }

    protected void reconnect(Object object) throws IOException {
        if (object instanceof ObjectImpl) {
            try {
                ObjectImpl objectImpl = (ObjectImpl)object;
                objectImpl._get_delegate();
            }
            catch (BAD_OPERATION e) {
                try {
                    Stub stub = (Stub)object;
                    ORB orb = (ORB)new InitialContext().lookup("java:comp/ORB");
                    stub.connect(orb);
                }
                catch (NamingException ne) {
                    throw EjbLogger.ROOT_LOGGER.failedToLookupORB();
                }
            }
        } else {
            throw EjbLogger.ROOT_LOGGER.notAnObjectImpl(object.getClass());
        }
    }

    public static HandleDelegate getDelegate() {
        try {
            InitialContext ctx = new InitialContext();
            return (HandleDelegate)ctx.lookup("java:comp/HandleDelegate");
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }
}

