/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;

final class FilterSpecClassResolverFilter
implements Function<String, Boolean> {
    public static final String DEFAULT_FILTER_SPEC = "!org.apache.commons.collections.functors.InvokerTransformer;!org.apache.commons.collections.functors.InstantiateTransformer;!org.apache.commons.collections4.functors.InvokerTransformer;!org.apache.commons.collections4.functors.InstantiateTransformer;!org.codehaus.groovy.runtime.ConvertedClosure;!org.codehaus.groovy.runtime.MethodClosure;!org.springframework.beans.factory.ObjectFactory;!com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl;!org.apache.xalan.xsltc.trax.TemplatesImpl";
    private static final OperationContext.AttachmentKey<FilterSpecClassResolverFilter> ATTACHMENT_KEY = OperationContext.AttachmentKey.create(FilterSpecClassResolverFilter.class);
    private final String filterSpec;
    private final List<String> parsedFilterSpecs;
    private final List<Function<String, Boolean>> unmarshallingFilters;
    private final boolean whitelistUnmarshalling;

    static FilterSpecClassResolverFilter getFilterForOperationContext(OperationContext operationContext) {
        FilterSpecClassResolverFilter result = (FilterSpecClassResolverFilter)operationContext.getAttachment(ATTACHMENT_KEY);
        if (result == null) {
            result = new FilterSpecClassResolverFilter();
            operationContext.attach(ATTACHMENT_KEY, (Object)result);
        }
        return result;
    }

    FilterSpecClassResolverFilter() {
        this(FilterSpecClassResolverFilter.getUnmarshallingFilterSpec());
    }

    private static String getUnmarshallingFilterSpec() {
        String disabled = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.ejb.unmarshalling.filter.disabled", null);
        if ("true".equalsIgnoreCase(disabled)) {
            return "";
        }
        String spec = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.experimental.ejb.unmarshalling.filter.spec", null);
        if (spec != null) {
            return spec;
        }
        return DEFAULT_FILTER_SPEC;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FilterSpecClassResolverFilter(String filterSpec) {
        Assert.checkNotNullParam((String)"filterSpec", (Object)filterSpec);
        this.filterSpec = filterSpec;
        if (filterSpec.isEmpty()) {
            this.parsedFilterSpecs = null;
            this.unmarshallingFilters = null;
            this.whitelistUnmarshalling = false;
            return;
        } else {
            this.parsedFilterSpecs = new ArrayList<String>(Arrays.asList(filterSpec.split(";")));
            this.unmarshallingFilters = new ArrayList<Function<String, Boolean>>(this.parsedFilterSpecs.size());
            ExactMatchFilter exactMatchWhitelist = null;
            ExactMatchFilter exactMatchBlacklist = null;
            boolean whitelist = false;
            for (String spec : this.parsedFilterSpecs) {
                void var9_9;
                Boolean matchReturn;
                if (spec.contains("=") || spec.contains("/")) {
                    throw EjbLogger.REMOTE_LOGGER.invalidFilterSpec(spec);
                }
                boolean blacklistElement = spec.startsWith("!");
                whitelist |= !blacklistElement;
                Boolean bl = matchReturn = blacklistElement ? Boolean.FALSE : Boolean.TRUE;
                if (blacklistElement) {
                    if (spec.length() == 1) {
                        throw EjbLogger.REMOTE_LOGGER.invalidFilterSpec(spec);
                    }
                    spec = spec.substring(1);
                }
                Object var9_10 = null;
                int lastStar = spec.lastIndexOf(42);
                if (lastStar >= 0) {
                    String pkg;
                    if (lastStar != spec.length() - 1) {
                        throw EjbLogger.REMOTE_LOGGER.invalidFilterSpec(spec);
                    }
                    int firstStar = spec.indexOf(42);
                    if (firstStar != lastStar) {
                        if (firstStar != lastStar - 1 || !spec.endsWith(".**")) throw EjbLogger.REMOTE_LOGGER.invalidFilterSpec(spec);
                        if (spec.length() == 3) {
                            throw EjbLogger.REMOTE_LOGGER.invalidFilterSpec(spec);
                        }
                        pkg = spec.substring(0, spec.length() - 2);
                        Function<String, Boolean> function = cName -> cName.startsWith(pkg) ? matchReturn : null;
                    } else if (spec.endsWith(".*")) {
                        if (spec.length() == 2) {
                            throw EjbLogger.REMOTE_LOGGER.invalidFilterSpec(spec);
                        }
                        pkg = spec.substring(0, spec.length() - 1);
                        Function<String, Boolean> function = cName -> cName.startsWith(pkg) && cName.lastIndexOf(46) == pkg.length() - 1 ? matchReturn : null;
                    } else {
                        String startsWith = spec.substring(0, spec.length() - 1);
                        Function<String, Boolean> function = cName -> cName.startsWith(startsWith) ? matchReturn : null;
                    }
                } else {
                    void var9_19;
                    if (blacklistElement) {
                        if (exactMatchBlacklist == null) {
                            ExactMatchFilter exactMatchFilter = exactMatchBlacklist = new ExactMatchFilter(false);
                        }
                        exactMatchBlacklist.addMatchingClass(spec);
                    } else {
                        if (exactMatchWhitelist == null) {
                            ExactMatchFilter exactMatchFilter = exactMatchWhitelist = new ExactMatchFilter(true);
                        }
                        exactMatchWhitelist.addMatchingClass(spec);
                    }
                    if (var9_19 == null) {
                        Function<String, Boolean> function = cName -> null;
                    }
                }
                this.unmarshallingFilters.add((Function<String, Boolean>)var9_9);
            }
            if (whitelist) {
                String pkg = "org.jboss.ejb.client.";
                this.parsedFilterSpecs.add("org.jboss.ejb.client.*");
                this.unmarshallingFilters.add(cName -> cName.startsWith("org.jboss.ejb.client.") && cName.lastIndexOf(46) == "org.jboss.ejb.client.".length() - 1 ? Boolean.valueOf(true) : null);
            }
            assert (this.parsedFilterSpecs.size() == this.unmarshallingFilters.size());
            this.whitelistUnmarshalling = whitelist;
        }
    }

    @Override
    public Boolean apply(String className) {
        Assert.checkNotNullParam((String)"className", (Object)className);
        boolean anyAccept = false;
        if (this.unmarshallingFilters != null) {
            for (int i = 0; i < this.unmarshallingFilters.size(); ++i) {
                Function<String, Boolean> func = this.unmarshallingFilters.get(i);
                Boolean accept = func.apply(className);
                if (accept == Boolean.FALSE) {
                    String failedSpec = func instanceof ExactMatchFilter ? "!" + className : this.parsedFilterSpecs.get(i);
                    EjbLogger.REMOTE_LOGGER.debugf("Class %s has been explicitly rejected by filter spec element %s", className, failedSpec);
                    return false;
                }
                anyAccept |= accept != null;
            }
            if (this.whitelistUnmarshalling && !anyAccept) {
                EjbLogger.REMOTE_LOGGER.debugf("Class %s has not been explicitly whitelisted by filter spec %s", className, this.filterSpec);
                return false;
            }
        }
        return true;
    }

    private static class ExactMatchFilter
    implements Function<String, Boolean> {
        private final Set<String> matches = new HashSet<String>();
        private final Boolean matchResult;

        private ExactMatchFilter(boolean forWhitelist) {
            this.matchResult = forWhitelist;
        }

        private void addMatchingClass(String name) {
            this.matches.add(name);
        }

        @Override
        public Boolean apply(String s) {
            return this.matches.contains(s) ? this.matchResult : null;
        }
    }
}

