/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.spi;

import jakarta.ejb.TimerConfig;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceApplicableComponentConfiguration;
import org.jboss.msc.service.ServiceName;

public interface ManagedTimerServiceConfiguration
extends TimerServiceApplicableComponentConfiguration {
    public TimedObjectInvoker getInvoker();

    public Predicate<TimerConfig> getTimerFilter();

    public static enum TimerFilter implements Predicate<TimerConfig>,
    UnaryOperator<ServiceName>
    {
        ALL{

            @Override
            public boolean test(TimerConfig config) {
                return true;
            }

            @Override
            public ServiceName apply(ServiceName name) {
                return name;
            }
        }
        ,
        TRANSIENT{

            @Override
            public boolean test(TimerConfig config) {
                return !config.isPersistent();
            }

            @Override
            public ServiceName apply(ServiceName name) {
                return name.append(new String[]{"transient"});
            }
        }
        ,
        PERSISTENT{

            @Override
            public boolean test(TimerConfig config) {
                return config.isPersistent();
            }

            @Override
            public ServiceName apply(ServiceName name) {
                return name.append(new String[]{"persistent"});
            }
        };


        @Override
        public ServiceName apply(ServiceName name) {
            return name.append(new String[]{this.name()});
        }
    }
}

