/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import jakarta.security.jacc.EJBMethodPermission;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Function;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.jacc.PolicyUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaccInterceptor
implements Interceptor {
    private static final Principal[] NO_PRINCIPALS = new Principal[0];
    private final String viewClassName;
    private final Method viewMethod;

    public JaccInterceptor(String viewClassName, Method viewMethod) {
        this.viewClassName = viewClassName;
        this.viewMethod = viewMethod;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        Component component = (Component)context.getPrivateData(Component.class);
        SecurityDomain securityDomain = (SecurityDomain)context.getPrivateData(SecurityDomain.class);
        Assert.checkNotNullParam((String)"securityDomain", (Object)securityDomain);
        SecurityIdentity currentIdentity = securityDomain.getCurrentSecurityIdentity();
        if (!(component instanceof EJBComponent)) {
            throw EjbLogger.ROOT_LOGGER.unexpectedComponent(component, EJBComponent.class);
        }
        Method invokedMethod = context.getMethod();
        ComponentView componentView = (ComponentView)context.getPrivateData(ComponentView.class);
        String viewClassOfInvokedMethod = componentView.getViewClass().getName();
        if (!this.viewClassName.equals(viewClassOfInvokedMethod) || !this.viewMethod.equals(invokedMethod)) {
            throw EjbLogger.ROOT_LOGGER.failProcessInvocation(this.getClass().getName(), invokedMethod, viewClassOfInvokedMethod, this.viewMethod, this.viewClassName);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        if (WildFlySecurityManager.isChecking()) {
            try {
                AccessController.doPrivileged(() -> {
                    this.hasPermission(ejbComponent, componentView, invokedMethod, currentIdentity);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        } else {
            this.hasPermission(ejbComponent, componentView, invokedMethod, currentIdentity);
        }
        return context.proceed();
    }

    private EJBMethodPermission createEjbMethodPermission(Method invokedMethod, EJBComponent ejbComponent, MethodInterfaceType methodIntfType) {
        return new EJBMethodPermission(ejbComponent.getComponentName(), methodIntfType.name(), invokedMethod);
    }

    private void hasPermission(EJBComponent ejbComponent, ComponentView componentView, Method method, SecurityIdentity securityIdentity) {
        PolicyUtil policyUtil;
        MethodInterfaceType methodIntfType = (MethodInterfaceType)componentView.getPrivateData(MethodInterfaceType.class);
        EJBMethodPermission permission = this.createEjbMethodPermission(method, ejbComponent, methodIntfType);
        ProtectionDomain domain = new ProtectionDomain(componentView.getProxyClass().getProtectionDomain().getCodeSource(), null, null, JaccInterceptor.getGrantedRoles(securityIdentity));
        PolicyUtil policyUtil2 = policyUtil = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(PolicyUtil::getPolicyUtil) : PolicyUtil.getPolicyUtil();
        if (!policyUtil.implies(domain, (Permission)permission)) {
            throw EjbLogger.ROOT_LOGGER.invocationOfMethodNotAllowed(method, ejbComponent.getComponentName());
        }
    }

    public static Principal[] getGrantedRoles(SecurityIdentity securityIdentity) {
        HashSet<String> roles = new HashSet<String>();
        for (String s : securityIdentity.getRoles("ejb")) {
            roles.add(s);
        }
        ArrayList<Principal> list = new ArrayList<Principal>();
        Function<String, Principal> mapper = roleName -> () -> roleName;
        for (String role : roles) {
            Principal principal = mapper.apply(role);
            list.add(principal);
        }
        return list.toArray(NO_PRINCIPALS);
    }
}

