/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop;

import jakarta.ejb.TransactionAttributeType;
import jakarta.transaction.Transaction;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.wildfly.iiop.openjdk.tm.ForeignTransaction;
import org.wildfly.iiop.openjdk.tm.TxServerInterceptor;

public class EjbIIOPTransactionInterceptor
implements Interceptor {
    public static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory((Interceptor)new EjbIIOPTransactionInterceptor());

    public Object processInvocation(InterceptorContext invocation) throws Exception {
        Transaction tx = TxServerInterceptor.getCurrentTransaction();
        if (tx instanceof ForeignTransaction) {
            TransactionAttributeType attr;
            EJBComponent component = (EJBComponent)((Object)invocation.getPrivateData(Component.class));
            MethodInterfaceType methodIntf = (MethodInterfaceType)invocation.getPrivateData(MethodInterfaceType.class);
            if (methodIntf == null) {
                ComponentView componentView = (ComponentView)invocation.getPrivateData(ComponentView.class);
                methodIntf = componentView != null ? (MethodInterfaceType)componentView.getPrivateData(MethodInterfaceType.class) : MethodInterfaceType.Bean;
            }
            if ((attr = component.getTransactionAttributeType(methodIntf, invocation.getMethod())) != TransactionAttributeType.NOT_SUPPORTED && attr != TransactionAttributeType.REQUIRES_NEW) {
                throw EjbLogger.ROOT_LOGGER.transactionPropagationNotSupported();
            }
        }
        return invocation.proceed();
    }
}

