/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.ejb3.remote.AssociationService;
import org.jboss.ejb.protocol.remote.RemoteEJBService;
import org.jboss.ejb.server.Association;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.ServiceRegistrationException;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionService;
import org.xnio.OptionMap;

public class EJBRemoteConnectorService
implements Service {
    private static final String EJB_CHANNEL_NAME = "jboss.ejb";
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "connector"});
    private final Consumer<EJBRemoteConnectorService> serviceConsumer;
    private final Supplier<Endpoint> endpointSupplier;
    private final Supplier<Executor> executorSupplier;
    private final Supplier<AssociationService> associationServiceSupplier;
    private final Supplier<RemotingTransactionService> remotingTransactionServiceSupplier;
    private volatile Registration registration;
    private final OptionMap channelCreationOptions;
    private final Function<String, Boolean> classResolverFilter;

    public EJBRemoteConnectorService(Consumer<EJBRemoteConnectorService> serviceConsumer, Supplier<Endpoint> endpointSupplier, Supplier<Executor> executorSupplier, Supplier<AssociationService> associationServiceSupplier, Supplier<RemotingTransactionService> remotingTransactionServiceSupplier, OptionMap channelCreationOptions, Function<String, Boolean> classResolverFilter) {
        this.serviceConsumer = serviceConsumer;
        this.endpointSupplier = endpointSupplier;
        this.executorSupplier = executorSupplier;
        this.associationServiceSupplier = associationServiceSupplier;
        this.remotingTransactionServiceSupplier = remotingTransactionServiceSupplier;
        this.channelCreationOptions = channelCreationOptions;
        this.classResolverFilter = classResolverFilter;
    }

    public void start(StartContext context) throws StartException {
        AssociationService associationService = this.associationServiceSupplier.get();
        Endpoint endpoint = this.endpointSupplier.get();
        Executor executor = this.executorSupplier.get();
        if (executor != null) {
            associationService.setExecutor(executor);
        }
        RemoteEJBService remoteEJBService = RemoteEJBService.create((Association)associationService.getAssociation(), (RemotingTransactionService)this.remotingTransactionServiceSupplier.get(), this.classResolverFilter);
        remoteEJBService.serverUp();
        OpenListener channelOpenListener = remoteEJBService.getOpenListener();
        try {
            this.registration = endpoint.registerService(EJB_CHANNEL_NAME, channelOpenListener, this.channelCreationOptions);
        }
        catch (ServiceRegistrationException e) {
            throw new StartException((Throwable)e);
        }
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        AssociationService associationService = this.associationServiceSupplier.get();
        associationService.sendTopologyUpdateIfLastNodeToLeave();
        associationService.setExecutor(null);
        this.registration.close();
    }
}

