/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ApplicationSecurityDomainService
implements Service {
    private final Supplier<SecurityDomain> securityDomainSupplier;
    private final Consumer<ApplicationSecurityDomain> applicationSecurityDomainConsumer;
    private final Consumer<SecurityDomain> securityDomainConsumer;
    private final Set<RegistrationImpl> registrations = new HashSet<RegistrationImpl>();
    private final boolean enableJacc;

    public ApplicationSecurityDomainService(boolean enableJacc, Supplier<SecurityDomain> securityDomainSupplier, Consumer<ApplicationSecurityDomain> applicationSecurityDomainConsumer, Consumer<SecurityDomain> securityDomainConsumer) {
        this.enableJacc = enableJacc;
        this.securityDomainSupplier = securityDomainSupplier;
        this.applicationSecurityDomainConsumer = applicationSecurityDomainConsumer;
        this.securityDomainConsumer = securityDomainConsumer;
    }

    public void start(StartContext context) throws StartException {
        SecurityDomain securityDomain = this.securityDomainSupplier.get();
        this.applicationSecurityDomainConsumer.accept(new ApplicationSecurityDomain(securityDomain, this.enableJacc));
        this.securityDomainConsumer.accept(securityDomain);
    }

    public void stop(StopContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDeployments() {
        Set<RegistrationImpl> set = this.registrations;
        synchronized (set) {
            HashSet<String> deploymentNames = new HashSet<String>();
            for (RegistrationImpl r : this.registrations) {
                String deploymentName = r.deploymentName;
                deploymentNames.add(deploymentName);
            }
            return deploymentNames.toArray(new String[deploymentNames.size()]);
        }
    }

    public final class ApplicationSecurityDomain {
        private final SecurityDomain securityDomain;
        private final boolean enableJacc;

        public ApplicationSecurityDomain(SecurityDomain securityDomain, boolean enableJacc) {
            this.securityDomain = securityDomain;
            this.enableJacc = enableJacc;
        }

        public SecurityDomain getSecurityDomain() {
            return this.securityDomain;
        }

        public boolean isEnableJacc() {
            return this.enableJacc;
        }

        public BiFunction<String, ClassLoader, Registration> getSecurityFunction() {
            return this::registerElytronDeployment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Registration registerElytronDeployment(String deploymentName, ClassLoader classLoader) {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(() -> {
                    this.securityDomain.registerWithClassLoader(classLoader);
                    return null;
                });
            } else {
                this.securityDomain.registerWithClassLoader(classLoader);
            }
            RegistrationImpl registration = new RegistrationImpl(deploymentName, classLoader);
            Set<RegistrationImpl> set = ApplicationSecurityDomainService.this.registrations;
            synchronized (set) {
                ApplicationSecurityDomainService.this.registrations.add(registration);
            }
            return registration;
        }
    }

    private class RegistrationImpl
    implements Registration {
        private final String deploymentName;
        private final ClassLoader classLoader;

        private RegistrationImpl(String deploymentName, ClassLoader classLoader) {
            this.deploymentName = deploymentName;
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(() -> {
                    SecurityDomain.unregisterClassLoader((ClassLoader)this.classLoader);
                    return null;
                });
            } else {
                SecurityDomain.unregisterClassLoader((ClassLoader)this.classLoader);
            }
            Set<RegistrationImpl> set = ApplicationSecurityDomainService.this.registrations;
            synchronized (set) {
                ApplicationSecurityDomainService.this.registrations.remove(this);
            }
        }
    }

    public static interface Registration {
        public void cancel();
    }
}

