/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import jakarta.transaction.Synchronization;
import java.util.function.Consumer;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.ejb.timer.Timer;

public class DistributableTimerSynchronizationFactory<I>
implements TimerSynchronizationFactory<I> {
    private final Consumer<Timer<I>> activateTask;
    private final Consumer<Timer<I>> cancelTask;

    public DistributableTimerSynchronizationFactory(Consumer<Timer<I>> activateTask, Consumer<Timer<I>> cancelTask) {
        this.activateTask = activateTask;
        this.cancelTask = cancelTask;
    }

    @Override
    public Consumer<Timer<I>> getActivateTask() {
        return this.activateTask;
    }

    @Override
    public Consumer<Timer<I>> getCancelTask() {
        return this.cancelTask;
    }

    @Override
    public Synchronization createActivateSynchronization(Timer<I> timer, SuspendedBatch suspendedBatch) {
        return new DistributableTimerSynchronization<I>(timer, suspendedBatch, this.activateTask, this.cancelTask);
    }

    @Override
    public Synchronization createCancelSynchronization(Timer<I> timer, SuspendedBatch suspendedBatch) {
        return new DistributableTimerSynchronization<I>(timer, suspendedBatch, this.cancelTask, this.activateTask);
    }

    private static class DistributableTimerSynchronization<I>
    implements Synchronization {
        private final Timer<I> timer;
        private final SuspendedBatch suspendedBatch;
        private final Consumer<Timer<I>> commitTask;
        private final Consumer<Timer<I>> rollbackTask;

        DistributableTimerSynchronization(Timer<I> timer, SuspendedBatch suspendedBatch, Consumer<Timer<I>> commitTask, Consumer<Timer<I>> rollbackTask) {
            this.timer = timer;
            this.suspendedBatch = suspendedBatch;
            this.commitTask = commitTask;
            this.rollbackTask = rollbackTask;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try (Context context = this.suspendedBatch.resumeWithContext();
                 Batch batch = (Batch)context.get();){
                if (!this.timer.isCanceled()) {
                    if (status == 3) {
                        this.commitTask.accept(this.timer);
                    } else {
                        this.rollbackTask.accept(this.timer);
                    }
                }
            }
        }
    }
}

