/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful.cache.simple;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBean;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstance;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstanceFactory;
import org.jboss.as.ejb3.component.stateful.cache.simple.SimpleStatefulSessionBean;
import org.jboss.as.ejb3.component.stateful.cache.simple.SimpleStatefulSessionBeanCacheConfiguration;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerService;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.scheduler.SchedulerService;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SimpleStatefulSessionBeanCache<K, V extends StatefulSessionBeanInstance<K>>
implements StatefulSessionBeanCache<K, V>,
Predicate<K>,
Consumer<StatefulSessionBean<K, V>> {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(SimpleStatefulSessionBeanCache.class, WildFlySecurityManager.getClassLoaderPrivileged(SimpleStatefulSessionBeanCache.class));
    private final Map<K, V> instances = new ConcurrentHashMap();
    private final Consumer<K> remover = this.instances::remove;
    private final StatefulSessionBeanInstanceFactory<V> factory;
    private final Supplier<K> identifierFactory;
    private final Duration timeout;
    private final Affinity strongAffinity;
    private final SchedulerService<K, Instant> scheduler;

    public SimpleStatefulSessionBeanCache(final SimpleStatefulSessionBeanCacheConfiguration<K, V> configuration) {
        this.factory = configuration.getInstanceFactory();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.timeout = configuration.getTimeout();
        this.strongAffinity = new NodeAffinity(configuration.getEnvironment().getNodeName());
        this.scheduler = this.timeout != null && !this.timeout.isZero() && !this.timeout.isNegative() ? new LocalSchedulerService(new LocalSchedulerService.Configuration<K>(){

            public String getName() {
                return configuration.getComponentName();
            }

            public ScheduledEntries<K, Instant> getScheduledEntries() {
                return ScheduledEntries.queued();
            }

            public Predicate<K> getTask() {
                return SimpleStatefulSessionBeanCache.this;
            }

            public ThreadFactory getThreadFactory() {
                return THREAD_FACTORY;
            }
        }) : null;
    }

    public boolean isStarted() {
        return this.scheduler != null ? this.scheduler.isStarted() : true;
    }

    public void start() {
        if (this.scheduler != null) {
            this.scheduler.start();
        }
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        for (StatefulSessionBeanInstance instance : this.instances.values()) {
            instance.removed();
        }
        this.instances.clear();
    }

    @Override
    public void close() {
        if (this.scheduler != null) {
            this.scheduler.close();
        }
    }

    public Affinity getStrongAffinity() {
        return this.strongAffinity;
    }

    public Affinity getWeakAffinity(K id) {
        return Affinity.NONE;
    }

    @Override
    public void accept(StatefulSessionBean<K, V> bean) {
        if (this.timeout != null) {
            K id = bean.getId();
            if (this.scheduler != null) {
                this.scheduler.schedule(id, (Object)Instant.now().plus(this.timeout));
            } else {
                this.test(id);
            }
        }
    }

    @Override
    public boolean test(K id) {
        StatefulSessionBeanInstance instance = (StatefulSessionBeanInstance)this.instances.remove(id);
        if (instance != null) {
            instance.removed();
        }
        return true;
    }

    @Override
    public StatefulSessionBean<K, V> createStatefulSessionBean() {
        if (CURRENT_GROUP.get() != null) {
            throw EjbLogger.ROOT_LOGGER.incompatibleCaches();
        }
        StatefulSessionBeanInstance instance = (StatefulSessionBeanInstance)this.factory.createInstance();
        Object id = instance.getId();
        this.instances.put(id, instance);
        return new SimpleStatefulSessionBean<K, StatefulSessionBeanInstance>(instance, this.remover, this);
    }

    @Override
    public StatefulSessionBean<K, V> findStatefulSessionBean(K id) {
        StatefulSessionBeanInstance instance = (StatefulSessionBeanInstance)this.instances.get(id);
        if (instance == null) {
            return null;
        }
        if (this.scheduler != null) {
            this.scheduler.cancel(id);
        }
        return new SimpleStatefulSessionBean<K, StatefulSessionBeanInstance>(instance, this.remover, this);
    }

    public int getActiveCount() {
        return this.instances.size();
    }

    public int getPassiveCount() {
        return 0;
    }

    @Override
    public Supplier<K> getIdentifierFactory() {
        return this.identifierFactory;
    }
}

