/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;

public abstract class AbstractEjbXmlDescriptorProcessor<T extends EnterpriseBeanMetaData>
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(AbstractEjbXmlDescriptorProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData == null) {
            return;
        }
        EnterpriseBeansMetaData ejbs = ejbJarMetaData.getEnterpriseBeans();
        if (ejbs != null && !ejbs.isEmpty()) {
            for (EnterpriseBeanMetaData ejb : ejbs) {
                if (!this.getMetaDataType().isInstance(ejb)) continue;
                this.processBeanMetaData(ejb, phaseContext);
            }
        }
    }

    protected abstract Class<T> getMetaDataType();

    protected abstract void processBeanMetaData(T var1, DeploymentPhaseContext var2) throws DeploymentUnitProcessingException;

    protected MethodIntf getMethodIntf(MethodInterfaceType viewType) {
        if (viewType == null) {
            return MethodIntf.BEAN;
        }
        switch (viewType) {
            case Home: {
                return MethodIntf.HOME;
            }
            case LocalHome: {
                return MethodIntf.LOCAL_HOME;
            }
            case ServiceEndpoint: {
                return MethodIntf.SERVICE_ENDPOINT;
            }
            case Local: {
                return MethodIntf.LOCAL;
            }
            case Remote: {
                return MethodIntf.REMOTE;
            }
        }
        return MethodIntf.BEAN;
    }

    protected String[] getMethodParams(MethodParametersMetaData methodParametersMetaData) {
        if (methodParametersMetaData == null) {
            return null;
        }
        return (String[])methodParametersMetaData.toArray((Object[])new String[0]);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

