/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded.ejb3;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.as.embedded.EmbeddedLogger;
import org.jboss.as.embedded.EmbeddedMessages;
import org.jboss.as.embedded.ejb3.BundleSymbolicNameExclusionFilter;
import org.jboss.as.embedded.ejb3.ExclusionFilter;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.wildfly.security.manager.WildFlySecurityManager;

class ClassPathEjbJarScanner {
    private static final String SYS_PROP_KEY_CLASS_PATH = "java.class.path";
    private static final String[] DUMMY = new String[0];
    private static final String PATH_EJB_JAR_XML = "META-INF/ejb-jar.xml";
    private static final String EXTENSION_CLASS = ".class";
    private static final String EXTENSION_JAR = ".jar";
    private static final Class<? extends Annotation>[] EJB_COMPONENT_ANNOTATIONS = new Class[]{Stateless.class, Stateful.class, Singleton.class, MessageDriven.class};
    @Deprecated
    private static final ScheduledExecutorService ses = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private static final String JAVA_HOME = WildFlySecurityManager.getPropertyPrivileged((String)"java.home", null);
    private static final List<ExclusionFilter> exclusionFilters = new ArrayList<ExclusionFilter>();

    private ClassPathEjbJarScanner() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static String[] getEjbJars(Map<?, ?> properties) {
        ArrayList<String> returnValue = new ArrayList<String>();
        String classPath = WildFlySecurityManager.getPropertyPrivileged((String)"surefire.test.class.path", null);
        if (classPath == null || classPath.isEmpty()) {
            classPath = WildFlySecurityManager.getPropertyPrivileged((String)SYS_PROP_KEY_CLASS_PATH, null);
        }
        if (EmbeddedLogger.ROOT_LOGGER.isTraceEnabled()) {
            EmbeddedLogger.ROOT_LOGGER.tracef("Class Path: %s", classPath);
        }
        String[] classPathEntries = classPath.split(File.pathSeparator);
        Object modules = properties != null ? (Object)properties.get("javax.ejb.embeddable.modules") : null;
        HashSet<String> moduleNames = null;
        if (modules != null) {
            if (modules instanceof File[]) {
                for (File file : (File[])modules) {
                    returnValue.add(file.getAbsolutePath());
                }
                return returnValue.toArray(DUMMY);
            }
            if (modules instanceof File) {
                returnValue.add(((File)modules).getAbsolutePath());
                return returnValue.toArray(DUMMY);
            }
            if (modules instanceof String[]) {
                moduleNames = new HashSet<String>();
                moduleNames.addAll(Arrays.asList((String[])modules));
            } else if (modules instanceof String) {
                moduleNames = new HashSet();
                moduleNames.add(modules.toString());
            } else {
                throw EmbeddedMessages.MESSAGES.invalidModuleType("javax.ejb.embeddable.modules", modules.getClass());
            }
        }
        for (String classPathEntry : classPathEntries) {
            String moduleName = ClassPathEjbJarScanner.getEjbJar(classPathEntry);
            if (moduleName == null) continue;
            if (moduleNames == null) {
                returnValue.add(classPathEntry);
                continue;
            }
            if (!moduleNames.contains(moduleName)) continue;
            returnValue.add(classPathEntry);
        }
        if (EmbeddedLogger.ROOT_LOGGER.isDebugEnabled()) {
            EmbeddedLogger.ROOT_LOGGER.debugf("EJB Modules discovered on ClassPath: %s", returnValue);
        }
        return returnValue.toArray(DUMMY);
    }

    private static String getEjbJar(String candidate) {
        String string;
        TempFileProvider provider;
        Closeable handle;
        block17: {
            VirtualFile file;
            block16: {
                block15: {
                    block14: {
                        if (candidate == null || candidate.isEmpty()) {
                            return null;
                        }
                        file = VFS.getChild((String)candidate);
                        for (ExclusionFilter exclusionFilter : exclusionFilters) {
                            if (!exclusionFilter.exclude(file)) continue;
                            if (EmbeddedLogger.ROOT_LOGGER.isTraceEnabled()) {
                                EmbeddedLogger.ROOT_LOGGER.tracef("%s matched %s for exclusion; skipping", exclusionFilter, file);
                            }
                            return null;
                        }
                        handle = null;
                        provider = null;
                        if (!file.exists()) break block14;
                        if (file.isDirectory()) {
                            handle = VFS.mountReal((File)file.getPhysicalFile(), (VirtualFile)file);
                            break block15;
                        }
                        if (file.getName().endsWith(EXTENSION_JAR)) {
                            provider = TempFileProvider.create((String)"jbossejbmodulescanner", (ScheduledExecutorService)ses);
                            handle = VFS.mountZip((File)file.getPhysicalFile(), (VirtualFile)file, (TempFileProvider)provider);
                            break block15;
                        }
                        EmbeddedLogger.ROOT_LOGGER.skippingUnknownFileType(file);
                        String string2 = null;
                        VFSUtils.safeClose((Closeable[])new Closeable[]{handle, provider});
                        return string2;
                    }
                    EmbeddedLogger.ROOT_LOGGER.fileNotFound(file);
                    String string3 = null;
                    VFSUtils.safeClose((Closeable[])new Closeable[]{handle, provider});
                    return string3;
                }
                VirtualFile ejbJarXml = file.getChild(PATH_EJB_JAR_XML);
                if (!ejbJarXml.exists()) break block16;
                if (EmbeddedLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EmbeddedLogger.ROOT_LOGGER.tracef("Found descriptor %s in %s", ejbJarXml.getPathNameRelativeTo(file), file);
                }
                String string4 = ClassPathEjbJarScanner.getModuleNameFromEjbJar(file, ejbJarXml);
                VFSUtils.safeClose((Closeable[])new Closeable[]{handle, provider});
                return string4;
            }
            if (!ClassPathEjbJarScanner.containsEjbComponentClass(file)) break block17;
            String string5 = ClassPathEjbJarScanner.getModuleNameFromFileName(file);
            VFSUtils.safeClose((Closeable[])new Closeable[]{handle, provider});
            return string5;
        }
        try {
            string = null;
        }
        catch (IOException e) {
            try {
                throw EmbeddedMessages.MESSAGES.cannotMountFile(e, candidate);
            }
            catch (Throwable throwable) {
                VFSUtils.safeClose((Closeable[])new Closeable[]{handle, provider});
                throw throwable;
            }
        }
        VFSUtils.safeClose((Closeable[])new Closeable[]{handle, provider});
        return string;
    }

    private static String getModuleNameFromEjbJar(VirtualFile file, VirtualFile ejbJarXml) {
        return ClassPathEjbJarScanner.getModuleNameFromFileName(file);
    }

    private static String getModuleNameFromFileName(VirtualFile file) {
        String moduleName = file.getName();
        int index = moduleName.lastIndexOf(46);
        if (index != -1) {
            return moduleName.substring(0, index - 1);
        }
        return moduleName;
    }

    @Deprecated
    private static boolean containsEjbComponentClass(VirtualFile file) {
        Indexer indexer = new Indexer();
        ClassPathEjbJarScanner.indexClasses(file, file, indexer);
        Index index = indexer.complete();
        for (Class<? extends Annotation> annotation : EJB_COMPONENT_ANNOTATIONS) {
            DotName annotationName = DotName.createSimple((String)annotation.getName());
            List classes = index.getAnnotations(annotationName);
            if (classes == null || classes.isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void indexClasses(VirtualFile root, VirtualFile file, Indexer indexer) {
        if (file == null) {
            throw EmbeddedMessages.MESSAGES.nullVar("file");
        }
        for (VirtualFile child : file.getChildren()) {
            String childName;
            if (child.isDirectory()) {
                ClassPathEjbJarScanner.indexClasses(root, child, indexer);
            }
            if (!(childName = child.getPathNameRelativeTo(root)).endsWith(EXTENSION_CLASS)) continue;
            InputStream stream = null;
            try {
                try {
                    stream = child.openStream();
                    indexer.index(stream);
                }
                catch (IOException e) {
                    EmbeddedLogger.ROOT_LOGGER.cannotLoadClassFile(e, child);
                }
            }
            finally {
                try {
                    if (stream == null) continue;
                    stream.close();
                }
                catch (IOException e) {
                    EmbeddedLogger.ROOT_LOGGER.errorClosingFile(e, child);
                }
            }
        }
    }

    static {
        exclusionFilters.add(new BundleSymbolicNameExclusionFilter("org.eclipse", "org.junit"));
        exclusionFilters.add(new ExclusionFilter(){

            @Override
            public boolean exclude(VirtualFile file) throws IllegalArgumentException {
                String pathName = file.getPathName();
                return pathName.startsWith(JAVA_HOME);
            }
        });
    }
}

