/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.dmr.ModelNode;

class AddDefaultValueResourceTransformer
implements ResourceTransformer {
    private Map<String, ModelNode> attributes;

    private AddDefaultValueResourceTransformer(Map<String, ModelNode> attributes) {
        this.attributes = attributes;
    }

    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (Map.Entry<String, ModelNode> entry : this.attributes.entrySet()) {
            if (model.hasDefined(entry.getKey())) continue;
            model.get(entry.getKey()).set(entry.getValue());
        }
        ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        childContext.processChildren(resource);
    }

    static AddDefaultValueResourceTransformer create(String name, ModelNode defaultValue) {
        return new AddDefaultValueResourceTransformer(Collections.singletonMap(name, defaultValue));
    }

    static class Builder {
        Map<String, ModelNode> map = new HashMap<String, ModelNode>();

        Builder() {
        }

        AddDefaultValueResourceTransformer build() {
            return new AddDefaultValueResourceTransformer(this.map);
        }

        Builder add(String name, ModelNode defaultValue) {
            this.map.put(name, defaultValue);
            return this;
        }

        static Builder createBuilder(String name, ModelNode defaultValue) {
            Builder builder = new Builder();
            builder.add(name, defaultValue);
            return builder;
        }
    }
}

