/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ServerGroupDeploymentAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final HostFileRepository fileRepository;

    public ServerGroupDeploymentAddHandler(HostFileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        Resource deploymentResource = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)}));
        ModelNode deployment = deploymentResource.getModel();
        String runtimeName = deployment.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString();
        String serverGroupName = this.getServerGroupName(operation);
        this.isRuntimeNameUniqueForServerGroup(serverGroupName, context, name, runtimeName);
        for (ModelNode content : deployment.require("content").asList()) {
            if (!content.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) continue;
            DeploymentAttributes.CONTENT_HASH.validateOperation(content);
            this.fileRepository.getDeploymentFiles(DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, content).asBytes());
        }
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        for (AttributeDefinition def : DeploymentAttributes.SERVER_GROUP_ADD_ATTRIBUTES) {
            def.validateAndSet(operation, subModel);
        }
        if (!DeploymentAttributes.RUNTIME_NAME_NILLABLE.resolveModelAttribute(context, subModel).isDefined()) {
            DeploymentAttributes.RUNTIME_NAME_NILLABLE.validateAndSet(deployment, subModel);
        }
        context.stepCompleted();
    }

    private void isRuntimeNameUniqueForServerGroup(String serverGroupName, OperationContext context, String name, String runtimeName) throws OperationFailedException {
        if (serverGroupName != null) {
            PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((String)"server-group", (String)serverGroupName), (PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment")});
            Set deployments = context.readResourceFromRoot(address).getChildren("deployment");
            for (Resource.ResourceEntry existingDeployment : deployments) {
                ModelNode existingDeploymentModel = existingDeployment.getModel();
                if (!existingDeploymentModel.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName()) || name.equals(existingDeployment.getName()) || !existingDeploymentModel.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString().equals(runtimeName)) continue;
                throw DomainControllerMessages.MESSAGES.runtimeNameMustBeUnique(existingDeployment.getName(), runtimeName, serverGroupName);
            }
        }
    }

    private String getServerGroupName(ModelNode operation) {
        if (operation.hasDefined("address")) {
            List adress = operation.get("address").asPropertyList();
            for (Property prop : adress) {
                if (!"server-group".equals(prop.getName())) continue;
                return prop.getValue().asString();
            }
        }
        return null;
    }
}

