/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import java.util.Arrays;
import java.util.HashSet;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.transformers.DomainTransformers;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class JSFSubsystemTransformers {
    private static final String JSF_SUBSYSTEM = "jsf";
    private static final String SLOT_ATTRIBUTE_NAME = "default-jsf-impl-slot";
    private static final String SLOT_DEFAULT_VALUE = "main";

    JSFSubsystemTransformers() {
    }

    static void registerTransformers120(TransformerRegistry registry, TransformersSubRegistration parent) {
        registry.registerSubsystemTransformers(JSF_SUBSYSTEM, (ModelVersionRange)DomainTransformers.IGNORED_SUBSYSTEMS, new ResourceTransformer(){

            public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                ModelNode slot;
                ModelNode model = resource.getModel();
                if (model.hasDefined(JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME) && !JSFSubsystemTransformers.SLOT_DEFAULT_VALUE.equals((slot = model.get(JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME)).asString())) {
                    context.getLogger().logAttributeWarning(address, DomainControllerMessages.MESSAGES.invalidJSFSlotValue(slot.asString()), JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME);
                }
                HashSet<String> attributes = new HashSet<String>();
                for (Property prop : resource.getModel().asPropertyList()) {
                    attributes.add(prop.getName());
                }
                attributes.remove(JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME);
                if (!attributes.isEmpty()) {
                    context.getLogger().logAttributeWarning(address, ControllerMessages.MESSAGES.attributesAreNotUnderstoodAndMustBeIgnored(), attributes);
                }
            }
        });
        TransformersSubRegistration jsfSubsystem = parent.registerSubResource(PathElement.pathElement((String)"subsystem", (String)JSF_SUBSYSTEM));
        jsfSubsystem.registerOperationTransformer("add", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                ModelNode slot;
                if (operation.hasDefined(JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME) && !JSFSubsystemTransformers.SLOT_DEFAULT_VALUE.equals((slot = operation.get(JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME)).asString())) {
                    return new OperationTransformer.TransformedOperation(operation, (OperationRejectionPolicy)new RejectionWithFailurePolicy(DomainControllerMessages.MESSAGES.invalidJSFSlotValue(slot.asString())), OperationResultTransformer.ORIGINAL_RESULT);
                }
                HashSet<String> attributes = new HashSet<String>();
                for (Property prop : operation.asPropertyList()) {
                    attributes.add(prop.getName());
                }
                attributes.remove(JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME);
                if (!attributes.isEmpty()) {
                    return new OperationTransformer.TransformedOperation(operation, (OperationRejectionPolicy)new RejectionWithFailurePolicy(DomainControllerMessages.MESSAGES.unknownAttributesFromSubsystemVersion("add", JSFSubsystemTransformers.JSF_SUBSYSTEM, context.getTarget().getSubsystemVersion(JSFSubsystemTransformers.JSF_SUBSYSTEM), attributes)), OperationResultTransformer.ORIGINAL_RESULT);
                }
                return DISCARD.transformOperation(context, address, operation);
            }
        });
        jsfSubsystem.registerOperationTransformer("write-attribute", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                String name = operation.require("name").asString();
                ModelNode value = operation.get("value");
                if (JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME.equals(name)) {
                    if (value.isDefined() && JSFSubsystemTransformers.SLOT_DEFAULT_VALUE.equals(value.asString())) {
                        return DISCARD.transformOperation(context, address, operation);
                    }
                    return new OperationTransformer.TransformedOperation(operation, (OperationRejectionPolicy)new RejectionWithFailurePolicy(DomainControllerMessages.MESSAGES.invalidJSFSlotValue(value.asString())), OperationResultTransformer.ORIGINAL_RESULT);
                }
                return new OperationTransformer.TransformedOperation(operation, (OperationRejectionPolicy)new RejectionWithFailurePolicy(DomainControllerMessages.MESSAGES.unknownAttributesFromSubsystemVersion("add", JSFSubsystemTransformers.JSF_SUBSYSTEM, context.getTarget().getSubsystemVersion(JSFSubsystemTransformers.JSF_SUBSYSTEM), Arrays.asList(name))), OperationResultTransformer.ORIGINAL_RESULT);
            }
        });
        jsfSubsystem.registerOperationTransformer("undefine-attribute", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                String attributeName = operation.require("name").asString();
                if (!JSFSubsystemTransformers.SLOT_ATTRIBUTE_NAME.equals(attributeName)) {
                    return DEFAULT.transformOperation(context, address, operation);
                }
                context.getLogger().logAttributeWarning(address, ControllerMessages.MESSAGES.attributesAreNotUnderstoodAndMustBeIgnored(), attributeName);
                return DISCARD.transformOperation(context, address, operation);
            }
        });
    }

    private static class RejectionWithFailurePolicy
    implements OperationRejectionPolicy {
        private final String failureDescription;

        public RejectionWithFailurePolicy(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        public boolean rejectOperation(ModelNode preparedResult) {
            return true;
        }

        public String getFailureDescription() {
            return this.failureDescription;
        }
    }
}

