/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class PackedInteger {
    PackedInteger() {
    }

    public static int readPackedInteger(DataInput input) throws IOException {
        byte b = input.readByte();
        if ((b & 0x80) == 128) {
            return PackedInteger.readPackedInteger(input) << 7 | b & 0x7F;
        }
        return b;
    }

    public static void writePackedInteger(DataOutput output, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("Only unsigned integer can be packed");
        }
        if (value > 127) {
            output.writeByte(value & 0x7F | 0x80);
            PackedInteger.writePackedInteger(output, value >> 7);
        } else {
            output.writeByte(value & 0xFF);
        }
    }
}

