/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.client.ClientRequest;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.Protocol;
import org.wildfly.httpclient.transaction.Constants;
import org.wildfly.httpclient.transaction.RequestType;

final class RequestBuilder {
    private RequestType requestType;
    private int version = Protocol.LATEST;
    private int timeout;
    private int flags;
    private String parentName;
    private Boolean onePhase;

    RequestBuilder() {
    }

    RequestBuilder setRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    RequestBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    RequestBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    RequestBuilder setFlags(int flags) {
        this.flags = flags;
        return this;
    }

    RequestBuilder setOnePhase(Boolean onePhase) {
        this.onePhase = onePhase;
        return this;
    }

    RequestBuilder setParent(String parentName) {
        this.parentName = parentName;
        return this;
    }

    ClientRequest createRequest(String prefix) {
        ClientRequest request = new ClientRequest();
        this.setRequestMethod(request);
        this.setRequestPath(request, prefix);
        this.setRequestHeaders(request);
        return request;
    }

    private void setRequestMethod(ClientRequest request) {
        request.setMethod(this.requestType.getMethod());
    }

    private void setRequestPath(ClientRequest request, String prefix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        RequestBuilder.appendPath(sb, "/txn", false);
        RequestBuilder.appendPath(sb, "/v" + this.version, false);
        RequestBuilder.appendPath(sb, this.requestType.getPath(), false);
        if (this.requestType == RequestType.XA_COMMIT) {
            sb.append((String)(this.onePhase != null && this.onePhase != false ? "?opc=" + Boolean.TRUE : ""));
        } else if (this.requestType == RequestType.XA_RECOVER) {
            RequestBuilder.appendPath(sb, this.parentName, false);
        }
        request.setPath(sb.toString());
    }

    private void setRequestHeaders(ClientRequest request) {
        if (this.requestType == RequestType.UT_BEGIN) {
            HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.ACCEPT, (String)(Constants.EXCEPTION + "," + Constants.NEW_TRANSACTION));
            HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Constants.TIMEOUT, (String)String.valueOf(this.timeout));
        } else if (this.requestType == RequestType.XA_RECOVER) {
            HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.ACCEPT, (String)(Constants.XID_LIST + "," + Constants.NEW_TRANSACTION));
            HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Constants.RECOVERY_PARENT_NAME, (String)this.parentName);
            HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Constants.RECOVERY_FLAGS, (String)String.valueOf(this.flags));
        } else {
            HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.ACCEPT, (ContentType)Constants.EXCEPTION);
            HeadersHelper.putRequestHeader((ClientRequest)request, (HttpString)Headers.CONTENT_TYPE, (ContentType)Constants.XID);
        }
    }

    private static void appendPath(StringBuilder sb, String path, boolean encode) {
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        sb.append(encode ? URLEncoder.encode(path, StandardCharsets.UTF_8) : path);
    }
}

