/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk;

import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import javax.naming.spi.ObjectFactory;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.InitialContext;
import org.jboss.as.naming.service.DefaultNamespaceContextSelectorService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.metadata.ejb.jboss.IORASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.wildfly.iiop.openjdk.ConfigValidator;
import org.wildfly.iiop.openjdk.IIOPInitializer;
import org.wildfly.iiop.openjdk.IIOPRootDefinition;
import org.wildfly.iiop.openjdk.PropertiesMap;
import org.wildfly.iiop.openjdk.csiv2.CSIV2IORToSocketInfo;
import org.wildfly.iiop.openjdk.csiv2.ElytronSASClientInterceptor;
import org.wildfly.iiop.openjdk.deployment.IIOPDependencyProcessor;
import org.wildfly.iiop.openjdk.deployment.IIOPMarkerProcessor;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.naming.jndi.JBossCNCtxFactory;
import org.wildfly.iiop.openjdk.rmi.DelegatingStubFactoryFactory;
import org.wildfly.iiop.openjdk.security.LegacySSLSocketFactory;
import org.wildfly.iiop.openjdk.security.NoSSLSocketFactory;
import org.wildfly.iiop.openjdk.security.SSLSocketFactory;
import org.wildfly.iiop.openjdk.service.CorbaNamingService;
import org.wildfly.iiop.openjdk.service.CorbaORBService;
import org.wildfly.iiop.openjdk.service.CorbaPOAService;
import org.wildfly.iiop.openjdk.service.IORSecConfigMetaDataService;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class IIOPSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final String SSL_CONTEXT_CAPABILITY = "org.wildfly.security.ssl-context";
    private static final String AUTH_CONTEXT_CAPABILITY = "org.wildfly.security.authentication-context";

    public IIOPSubsystemAdd(Collection<? extends AttributeDefinition> attributes) {
        super(attributes);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
                ModelNode node = Resource.Tools.readModel((Resource)resource);
                IIOPSubsystemAdd.this.launchServices(context, node);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        ModelNode model = resource.getModel();
        ConfigValidator.validateConfig(context, model);
    }

    protected void launchServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String authContext;
        String clientSSLContextName;
        String serverSSLContextName;
        IIOPLogger.ROOT_LOGGER.activatingSubsystem();
        WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.com.sun.CORBA.ORBUseDynamicStub", (String)"true");
        ORB.getPresentationManager().setStubFactoryFactory(true, (PresentationManager.StubFactoryFactory)new DelegatingStubFactoryFactory());
        ORB.getPresentationManager().setStubFactoryFactory(false, (PresentationManager.StubFactoryFactory)new DelegatingStubFactoryFactory());
        InitialContext.addUrlContextFactory((String)"corbaloc", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"corbaname", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"IOR", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"iiopname", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        InitialContext.addUrlContextFactory((String)"iiop", (ObjectFactory)JBossCNCtxFactory.INSTANCE);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("iiop-openjdk", Phase.DEPENDENCIES, 4992, (DeploymentUnitProcessor)new IIOPDependencyProcessor());
                processorTarget.addDeploymentProcessor("iiop-openjdk", Phase.PARSE, 16768, (DeploymentUnitProcessor)new IIOPMarkerProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        Properties props = this.getConfigurationProperties(context, model);
        this.setupInitializers(props);
        boolean sslConfigured = this.setupSSLFactories(props);
        CorbaORBService orbService = new CorbaORBService(props);
        ServiceBuilder builder = context.getServiceTarget().addService(CorbaORBService.SERVICE_NAME, (Service)orbService);
        Services.addServerExecutorDependency((ServiceBuilder)builder, orbService.getExecutorInjector());
        String securityDomain = props.getProperty("security-domain");
        if (securityDomain != null) {
            builder.addDependency(context.getCapabilityServiceName("org.wildfly.security.legacy-security-domain", securityDomain, null));
            builder.addDependency(DefaultNamespaceContextSelectorService.SERVICE_NAME);
        }
        if ((serverSSLContextName = props.getProperty("server-ssl-context")) != null) {
            ServiceName serverContextServiceName = context.getCapabilityServiceName(SSL_CONTEXT_CAPABILITY, serverSSLContextName, SSLContext.class);
            builder.addDependency(serverContextServiceName);
        }
        if ((clientSSLContextName = props.getProperty("client-ssl-context")) != null) {
            ServiceName clientContextServiceName = context.getCapabilityServiceName(SSL_CONTEXT_CAPABILITY, clientSSLContextName, SSLContext.class);
            builder.addDependency(clientContextServiceName);
        }
        if ((authContext = props.getProperty("authentication-context")) != null) {
            ServiceName authContextServiceName = context.getCapabilityServiceName(AUTH_CONTEXT_CAPABILITY, authContext, AuthenticationContext.class);
            builder.addDependency(authContextServiceName);
        }
        String socketBinding = props.getProperty("socket-binding");
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding}), SocketBinding.class, orbService.getIIOPSocketBindingInjector());
        String sslSocketBinding = props.getProperty("ssl-socket-binding");
        if (sslSocketBinding != null) {
            builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{sslSocketBinding}), SocketBinding.class, orbService.getIIOPSSLSocketBindingInjector());
        }
        IORSecurityConfigMetaData securityConfigMetaData = this.createIORSecurityConfigMetaData(context, model, sslConfigured);
        IORSecConfigMetaDataService securityConfigMetaDataService = new IORSecConfigMetaDataService(securityConfigMetaData);
        context.getServiceTarget().addService(IORSecConfigMetaDataService.SERVICE_NAME, (Service)securityConfigMetaDataService).setInitialMode(ServiceController.Mode.ACTIVE).install();
        builder.addDependency(IORSecConfigMetaDataService.SERVICE_NAME);
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        CorbaPOAService rootPOAService = new CorbaPOAService("RootPOA", "poa");
        context.getServiceTarget().addService(CorbaPOAService.ROOT_SERVICE_NAME, (Service)rootPOAService).addDependency(CorbaORBService.SERVICE_NAME, org.omg.CORBA.ORB.class, rootPOAService.getORBInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        CorbaPOAService irPOAService = new CorbaPOAService("IRPOA", "irpoa", IdAssignmentPolicyValue.USER_ID, null, null, LifespanPolicyValue.PERSISTENT, null, null, null);
        context.getServiceTarget().addService(CorbaPOAService.INTERFACE_REPOSITORY_SERVICE_NAME, (Service)irPOAService).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, irPOAService.getParentPOAInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        CorbaPOAService namingPOAService = new CorbaPOAService("Naming", null, IdAssignmentPolicyValue.USER_ID, null, null, LifespanPolicyValue.PERSISTENT, null, null, null);
        context.getServiceTarget().addService(CorbaPOAService.SERVICE_NAME.append(new String[]{"namingpoa"}), (Service)namingPOAService).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, namingPOAService.getParentPOAInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        CorbaNamingService namingService = new CorbaNamingService(props);
        context.getServiceTarget().addService(CorbaNamingService.SERVICE_NAME, (Service)namingService).addDependency(CorbaORBService.SERVICE_NAME, org.omg.CORBA.ORB.class, namingService.getORBInjector()).addDependency(CorbaPOAService.ROOT_SERVICE_NAME, POA.class, namingService.getRootPOAInjector()).addDependency(CorbaPOAService.SERVICE_NAME.append(new String[]{"namingpoa"}), POA.class, namingService.getNamingPOAInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        this.configureClientSecurity(props);
    }

    protected Properties getConfigurationProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        Properties props = new Properties();
        this.getResourceProperties(props, IIOPRootDefinition.INSTANCE, context, model);
        ModelNode configNode = model.get("configuration");
        if (configNode.hasDefined("properties")) {
            for (Property property : configNode.get("properties").get("property").asPropertyList()) {
                String name = property.getName();
                String value = property.getValue().get("value").asString();
                props.setProperty(name, value);
            }
        }
        return props;
    }

    private void getResourceProperties(Properties properties, PersistentResourceDefinition resource, OperationContext context, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attrDefinition : resource.getAttributes()) {
            if (attrDefinition instanceof PropertiesAttributeDefinition) {
                PropertiesAttributeDefinition pad = (PropertiesAttributeDefinition)attrDefinition;
                ModelNode resolvedModelAttribute = attrDefinition.resolveModelAttribute(context, model);
                if (!resolvedModelAttribute.isDefined()) continue;
                for (Property prop : resolvedModelAttribute.asPropertyList()) {
                    properties.setProperty(prop.getName(), prop.getValue().asString());
                }
                continue;
            }
            ModelNode resolvedModelAttribute = attrDefinition.resolveModelAttribute(context, model);
            if (!resolvedModelAttribute.isDefined()) continue;
            String name = attrDefinition.getName();
            String value = resolvedModelAttribute.asString();
            String openjdkProperty = PropertiesMap.PROPS_MAP.get(name);
            if (openjdkProperty != null) {
                name = openjdkProperty;
            }
            properties.setProperty(name, value);
        }
    }

    private void setupInitializers(Properties props) {
        ArrayList<String> orbInitializers = new ArrayList<String>();
        String installSecurity = (String)props.remove("security");
        if (installSecurity.equalsIgnoreCase("client")) {
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.SECURITY_CLIENT.getInitializerClasses()));
        } else if (installSecurity.equalsIgnoreCase("identity")) {
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.SECURITY_IDENTITY.getInitializerClasses()));
        } else if (installSecurity.equalsIgnoreCase("elytron")) {
            String authContext = props.getProperty("authentication-context");
            ElytronSASClientInterceptor.setAuthenticationContextName(authContext);
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.SECURITY_ELYTRON.getInitializerClasses()));
        }
        String installTransaction = (String)props.remove("transactions");
        if (installTransaction.equalsIgnoreCase("full")) {
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.TRANSACTIONS.getInitializerClasses()));
        } else if (installTransaction.equalsIgnoreCase("spec")) {
            orbInitializers.addAll(Arrays.asList(IIOPInitializer.SPEC_TRANSACTIONS.getInitializerClasses()));
        }
        for (String initializerClass : orbInitializers) {
            props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass." + initializerClass, "");
        }
    }

    private boolean setupSSLFactories(Properties props) throws OperationFailedException {
        boolean sslConfigured;
        boolean supportSSL = "true".equalsIgnoreCase(props.getProperty("support-ssl"));
        if (supportSSL) {
            String serverSSLContextName = props.getProperty("server-ssl-context");
            String clientSSLContextName = props.getProperty("client-ssl-context");
            if (serverSSLContextName != null && clientSSLContextName != null) {
                SSLSocketFactory.setServerSSLContextName(serverSSLContextName);
                SSLSocketFactory.setClientSSLContextName(clientSSLContextName);
                props.setProperty("com.sun.CORBA.transport.ORBSocketFactoryClass", SSLSocketFactory.class.getName());
            } else {
                String securityDomain = props.getProperty("security-domain");
                LegacySSLSocketFactory.setSecurityDomain(securityDomain);
                props.setProperty("com.sun.CORBA.transport.ORBSocketFactoryClass", LegacySSLSocketFactory.class.getName());
            }
            sslConfigured = true;
        } else {
            props.setProperty("com.sun.CORBA.transport.ORBSocketFactoryClass", NoSSLSocketFactory.class.getName());
            sslConfigured = false;
        }
        return sslConfigured;
    }

    private IORSecurityConfigMetaData createIORSecurityConfigMetaData(OperationContext context, ModelNode resourceModel, boolean sslConfigured) throws OperationFailedException {
        IORSecurityConfigMetaData securityConfigMetaData = new IORSecurityConfigMetaData();
        IORSASContextMetaData sasContextMetaData = new IORSASContextMetaData();
        sasContextMetaData.setCallerPropagation(IIOPRootDefinition.CALLER_PROPAGATION.resolveModelAttribute(context, resourceModel).asString());
        securityConfigMetaData.setSasContext(sasContextMetaData);
        IORASContextMetaData asContextMetaData = new IORASContextMetaData();
        asContextMetaData.setAuthMethod(IIOPRootDefinition.AUTH_METHOD.resolveModelAttribute(context, resourceModel).asString());
        if (resourceModel.hasDefined(IIOPRootDefinition.REALM.getName())) {
            asContextMetaData.setRealm(IIOPRootDefinition.REALM.resolveModelAttribute(context, resourceModel).asString());
        }
        asContextMetaData.setRequired(IIOPRootDefinition.REQUIRED.resolveModelAttribute(context, resourceModel).asBoolean());
        securityConfigMetaData.setAsContext(asContextMetaData);
        boolean serverRequiresSsl = IIOPRootDefinition.SERVER_REQUIRES_SSL.resolveModelAttribute(context, resourceModel).asBoolean();
        IORTransportConfigMetaData transportConfigMetaData = new IORTransportConfigMetaData();
        ModelNode integrityNode = IIOPRootDefinition.INTEGRITY.resolveModelAttribute(context, resourceModel);
        if (integrityNode.isDefined()) {
            transportConfigMetaData.setIntegrity(integrityNode.asString());
        } else {
            transportConfigMetaData.setIntegrity(sslConfigured ? (serverRequiresSsl ? "required" : "supported") : "none");
        }
        ModelNode confidentialityNode = IIOPRootDefinition.CONFIDENTIALITY.resolveModelAttribute(context, resourceModel);
        if (confidentialityNode.isDefined()) {
            transportConfigMetaData.setConfidentiality(confidentialityNode.asString());
        } else {
            transportConfigMetaData.setConfidentiality(sslConfigured ? (serverRequiresSsl ? "required" : "supported") : "none");
        }
        ModelNode establishTrustInTargetNode = IIOPRootDefinition.TRUST_IN_TARGET.resolveModelAttribute(context, resourceModel);
        if (establishTrustInTargetNode.isDefined()) {
            transportConfigMetaData.setEstablishTrustInTarget(confidentialityNode.asString());
        } else {
            transportConfigMetaData.setEstablishTrustInTarget(sslConfigured ? "supported" : "none");
        }
        ModelNode establishTrustInClientNode = IIOPRootDefinition.TRUST_IN_CLIENT.resolveModelAttribute(context, resourceModel);
        if (establishTrustInClientNode.isDefined()) {
            transportConfigMetaData.setEstablishTrustInClient(establishTrustInClientNode.asString());
        } else {
            transportConfigMetaData.setEstablishTrustInClient(sslConfigured ? (serverRequiresSsl ? "required" : "supported") : "none");
        }
        transportConfigMetaData.setDetectMisordering("supported");
        transportConfigMetaData.setDetectReplay("supported");
        securityConfigMetaData.setTransportConfig(transportConfigMetaData);
        return securityConfigMetaData;
    }

    private void configureClientSecurity(Properties props) {
        boolean clientRequiresSSL = Boolean.getBoolean(props.getProperty("client-requires-ssl"));
        CSIV2IORToSocketInfo.setClientRequiresSSL(clientRequiresSSL);
    }
}

