/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.extension.AbstractLegacyExtension;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jaxr.extension.JAXRConstants;
import org.jboss.as.jaxr.extension.JAXRSubsystemParser;
import org.jboss.as.jaxr.extension.JAXRSubsystemRootResource;
import org.jboss.as.jaxr.extension.JAXRSubsystemWriter;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JAXRExtension
extends AbstractLegacyExtension {
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    static final String SUBSYSTEM_NAME = "jaxr";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"jaxr");
    private static final String RESOURCE_NAME = "org.jboss.as.jaxr.LocalDescriptions";

    static ResourceDescriptionResolver getResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, JAXRExtension.class.getClassLoader(), true, false);
    }

    public JAXRExtension() {
        super("org.jboss.as.jaxr", new String[]{SUBSYSTEM_NAME});
    }

    protected Set<ManagementResourceRegistration> initializeLegacyModel(ExtensionContext context) {
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)JAXRSubsystemWriter.INSTANCE);
        ManagementResourceRegistration subsystemRoot = subsystemRegistration.registerSubsystemModel((ResourceDefinition)new JAXRSubsystemRootResource());
        if (context.isRegisterTransformers()) {
            JAXRSubsystemRootResource.registerTransformerers(subsystemRegistration);
        }
        return Collections.singleton(subsystemRoot);
    }

    protected void initializeLegacyParsers(ExtensionParsingContext context) {
        JAXRSubsystemParser parser = new JAXRSubsystemParser();
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JAXRConstants.Namespace.JAXR_1_1.getUriString(), (XMLElementReader)parser);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, JAXRConstants.Namespace.JAXR_1_0.getUriString(), (XMLElementReader)parser);
    }
}

