package org.jboss.as.jaxrs.logging;

import java.util.Locale;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-10-23T22:24:12-0500")
public class JaxrsLogger_$logger extends DelegatingBasicLogger implements JaxrsLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JaxrsLogger_$logger.class.getName();
    public JaxrsLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void classAnnotationNotFound(final String annotation, final AnnotationTarget target) {
        super.log.logf(FQCN, WARN, null, classAnnotationNotFound$str(), annotation, target);
    }
    private static final String classAnnotationNotFound = "WFLYRS0001: %s annotation not on Class: %s";
    protected String classAnnotationNotFound$str() {
        return classAnnotationNotFound;
    }
    @Override
    public final void classOrMethodAnnotationNotFound(final String annotation, final AnnotationTarget target) {
        super.log.logf(FQCN, WARN, null, classOrMethodAnnotationNotFound$str(), annotation, target);
    }
    private static final String classOrMethodAnnotationNotFound = "WFLYRS0002: %s annotation not on Class or Method: %s";
    protected String classOrMethodAnnotationNotFound$str() {
        return classOrMethodAnnotationNotFound;
    }
    @Override
    public final void moreThanOneServletMapping(final String servletName, final String pattern) {
        super.log.logf(FQCN, ERROR, null, moreThanOneServletMapping$str(), servletName, pattern);
    }
    private static final String moreThanOneServletMapping = "WFLYRS0003: More than one mapping found for JAX-RS servlet: %s the second mapping %s will not work";
    protected String moreThanOneServletMapping$str() {
        return moreThanOneServletMapping;
    }
    private static final String cannotLoadApplicationClass = "WFLYRS0006: Could not load JAX-RS Application class";
    protected String cannotLoadApplicationClass$str() {
        return cannotLoadApplicationClass;
    }
    @Override
    public final DeploymentUnitProcessingException cannotLoadApplicationClass(final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotLoadApplicationClass$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String typeNameNotAnEjbView = "WFLYRS0010: JAX-RS resource %s does not correspond to a view on the EJB %s. @Path annotations can only be placed on classes or interfaces that represent a local, remote or no-interface view of an EJB.";
    protected String typeNameNotAnEjbView$str() {
        return typeNameNotAnEjbView;
    }
    @Override
    public final DeploymentUnitProcessingException typeNameNotAnEjbView(final java.util.List<Class<?>> type, final String ejbName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), typeNameNotAnEjbView$str(), type, ejbName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidParamValue = "WFLYRS0011: Invalid value for parameter %s: %s";
    protected String invalidParamValue$str() {
        return invalidParamValue;
    }
    @Override
    public final DeploymentUnitProcessingException invalidParamValue(final String param, final String value) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidParamValue$str(), param, value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSpringIntegrationJar = "WFLYRS0012: No spring integration jar found";
    protected String noSpringIntegrationJar$str() {
        return noSpringIntegrationJar;
    }
    @Override
    public final DeploymentUnitProcessingException noSpringIntegrationJar() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), noSpringIntegrationJar$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void disablePropertyDeprecated() {
        super.log.logf(FQCN, WARN, null, disablePropertyDeprecated$str());
    }
    private static final String disablePropertyDeprecated = "WFLYRS0013: The context param org.jboss.as.jaxrs.disableSpringIntegration is deprecated, and will be removed in a future release. Please use org.jboss.as.jaxrs.enableSpringIntegration instead";
    protected String disablePropertyDeprecated$str() {
        return disablePropertyDeprecated;
    }
    @Override
    public final void failedToRegisterManagementViewForRESTResources(final String resClass, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToRegisterManagementViewForRESTResources$str(), resClass);
    }
    private static final String failedToRegisterManagementViewForRESTResources = "WFLYRS0014: Failed to register management view for REST resource class: %s";
    protected String failedToRegisterManagementViewForRESTResources$str() {
        return failedToRegisterManagementViewForRESTResources;
    }
    @Override
    public final void noServletDeclaration(final String archiveName) {
        super.log.logf(FQCN, WARN, null, noServletDeclaration$str(), archiveName);
    }
    private static final String noServletDeclaration = "WFLYRS0015: No Servlet declaration found for JAX-RS application.  In %s either provide a class that extends javax.ws.rs.core.Application or declare a servlet class in web.xml.";
    protected String noServletDeclaration$str() {
        return noServletDeclaration;
    }
    @Override
    public final void resteasyVersion(final String version) {
        super.log.logf(FQCN, INFO, null, resteasyVersion$str(), version);
    }
    private static final String resteasyVersion = "WFLYRS0016: RESTEasy version %s";
    protected String resteasyVersion$str() {
        return resteasyVersion;
    }
}
