/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.ZipException;
import org.jboss.as.jdr.commands.JdrCommand;
import org.jboss.as.jdr.logger.JdrLogger;
import org.jboss.as.jdr.util.Utils;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.automount.Automounter;
import org.jboss.vfs.util.automount.MountOption;

public class JarCheck
extends JdrCommand {
    StringBuilder buffer;

    @Override
    public void execute() throws Exception {
        this.buffer = new StringBuilder();
        this.walk(VFS.getChild((String)this.env.getJbossHome()));
        this.env.getZip().add(this.buffer.toString(), "jarcheck.txt");
    }

    private void walk(VirtualFile root) throws NoSuchAlgorithmException {
        for (VirtualFile f : root.getChildren()) {
            if (f.isDirectory()) {
                this.walk(f);
                continue;
            }
            this.check(f);
        }
    }

    private void check(VirtualFile f) throws NoSuchAlgorithmException {
        try {
            MessageDigest alg = MessageDigest.getInstance("md5");
            byte[] buffer = Utils.toBytes(f);
            alg.update(buffer);
            String sum = new BigInteger(1, alg.digest()).toString(16);
            this.buffer.append(f.getPathName().replace(this.env.getJbossHome(), "JBOSSHOME") + "\n" + sum + "\n" + this.getManifestString(f) + "===");
        }
        catch (ZipException ze) {
        }
        catch (FileNotFoundException fnfe) {
            JdrLogger.ROOT_LOGGER.debug(fnfe);
        }
        catch (IOException ioe) {
            JdrLogger.ROOT_LOGGER.debug(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getManifestString(VirtualFile file) throws IOException {
        try {
            Automounter.mount((VirtualFile)file, (MountOption[])new MountOption[0]);
            String result = Utils.toString(file.getChild("META-INF/MANIFEST.MF"));
            String string = result != null ? result : "";
            return string;
        }
        catch (Exception npe) {
            JdrLogger.ROOT_LOGGER.tracef("no MANIFEST present", new Object[0]);
            String string = "";
            return string;
        }
        finally {
            if (Automounter.isMounted((VirtualFile)file)) {
                Automounter.cleanup((VirtualFile)file);
            }
        }
    }
}

