/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr.logger;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYJDR", length=4)
public interface JdrLogger
extends BasicLogger {
    public static final JdrLogger ROOT_LOGGER = (JdrLogger)Logger.getMessageLogger(JdrLogger.class, (String)"org.jboss.as.jdr");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Starting creation of a JBoss Diagnostic Report (JDR).")
    public void startingCollection();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Completed creation of a JBoss Diagnostic Report (JDR).")
    public void endingCollection();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="Unable to create JDR report, JBoss Home directory cannot be determined.")
    public void jbossHomeNotSet();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="JDR python interpreter encountered an exception.")
    public void pythonExceptionEncountered(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Unable to decode a url while creating JDR report.")
    public void urlDecodeExceptionEncountered(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Plugin contrib location is not a directory.  Ignoring.")
    public void contribNotADirectory();

    @Message(id=7, value="Could not create zipfile.")
    public String couldNotCreateZipfile();

    @Message(id=8, value="Could not configure JDR. At least one configuration step failed.")
    public String couldNotConfigureJDR();

    @Message(id=9, value="No JDR commands were loaded. Be sure that a valid Plugin class is specified in plugins.properties.")
    public String noCommandsToRun();

    @Message(id=10, value="Parameter %s may not be null.")
    public IllegalArgumentException varNull(String var1);

    @Message(id=0, value="Display this message and exit")
    public String jdrHelpMessage();

    @Message(id=0, value="hostname that the management api is bound to. (default: localhost)")
    public String jdrHostnameMessage();

    @Message(id=0, value="port that the management api is bound to. (default: 9990)")
    public String jdrPortMessage();

    @Message(id=0, value="Protocol that is used to connect. Can be remote, http or https (default: http)")
    public String jdrProtocolMessage();
}

