/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Properties;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.JdrReportCollector;
import org.jboss.as.jdr.Namespace;
import org.jboss.as.jdr.commands.JdrCommand;
import org.jboss.as.jdr.commands.JdrEnvironment;
import org.jboss.as.jdr.logger.JdrLogger;
import org.jboss.as.jdr.plugins.JdrPlugin;
import org.jboss.as.jdr.util.JdrZipFile;

public class JdrRunner
implements JdrReportCollector {
    JdrEnvironment env = new JdrEnvironment();
    CommandContext ctx;

    public JdrRunner() {
    }

    public JdrRunner(String protocol, String user, String pass, String host, String port) {
        this.env.setUsername(user);
        this.env.setPassword(pass);
        this.env.setHost(host);
        this.env.setPort(port);
        try {
            this.ctx = CommandContextFactory.getInstance().newCommandContext(this.constructUri(protocol, host, Integer.parseInt(port)), null, null);
            this.ctx.connectController();
            this.env.setClient(this.ctx.getModelControllerClient());
        }
        catch (Exception e) {
            this.ctx.terminateSession();
        }
    }

    @Override
    public JdrReport collect() throws OperationFailedException {
        try {
            this.env.setZip(new JdrZipFile(new JdrEnvironment(this.env)));
        }
        catch (Exception e) {
            JdrLogger.ROOT_LOGGER.error(JdrLogger.ROOT_LOGGER.couldNotCreateZipfile(), e);
            throw new OperationFailedException(JdrLogger.ROOT_LOGGER.couldNotCreateZipfile());
        }
        ArrayList<JdrCommand> commands = new ArrayList<JdrCommand>();
        ByteArrayOutputStream versionStream = new ByteArrayOutputStream();
        PrintWriter versionWriter = new PrintWriter(new OutputStreamWriter(versionStream));
        versionWriter.println("JDR: " + Namespace.CURRENT.getUriString());
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("plugins.properties");
            Properties plugins = new Properties();
            plugins.load(is);
            for (String pluginName : plugins.stringPropertyNames()) {
                Class<?> pluginClass = Class.forName(pluginName);
                JdrPlugin plugin = (JdrPlugin)pluginClass.newInstance();
                commands.addAll(plugin.getCommands());
                versionWriter.println(plugin.getPluginId());
            }
            versionWriter.close();
            this.env.getZip().add(new ByteArrayInputStream(versionStream.toByteArray()), "version.txt");
        }
        catch (Exception e) {
            JdrLogger.ROOT_LOGGER.error(JdrLogger.ROOT_LOGGER.couldNotConfigureJDR(), e);
            throw new OperationFailedException(JdrLogger.ROOT_LOGGER.couldNotConfigureJDR());
        }
        if (commands.size() < 1) {
            JdrLogger.ROOT_LOGGER.error(JdrLogger.ROOT_LOGGER.noCommandsToRun());
            throw new OperationFailedException(JdrLogger.ROOT_LOGGER.noCommandsToRun());
        }
        JdrReport report = new JdrReport();
        StringBuilder skips = new StringBuilder();
        report.setStartTime();
        for (JdrCommand command : commands) {
            command.setEnvironment(new JdrEnvironment(this.env));
            try {
                command.execute();
            }
            catch (Throwable t) {
                String message = "Skipping command " + command.toString();
                JdrLogger.ROOT_LOGGER.debugf(message, new Object[0]);
                skips.append(message);
                PrintWriter pw = new PrintWriter(new StringWriter());
                t.printStackTrace(pw);
                skips.append(pw.toString());
                pw.close();
            }
        }
        try {
            this.env.getZip().addLog(skips.toString(), "skips.log");
        }
        catch (Exception e) {
            JdrLogger.ROOT_LOGGER.debugf(e, "Could not add skipped commands log to jdr zip file.", new Object[0]);
        }
        try {
            this.env.getZip().close();
        }
        catch (Exception e) {
            JdrLogger.ROOT_LOGGER.debugf(e, "Could not close zip file.", new Object[0]);
        }
        report.setEndTime();
        report.setLocation(this.env.getZip().name());
        try {
            this.ctx.terminateSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        return report;
    }

    public void setJbossHomeDir(String dir) {
        this.env.setJbossHome(dir);
    }

    public void setReportLocationDir(String dir) {
        this.env.setOutputDirectory(dir);
    }

    public void setControllerClient(ModelControllerClient client) {
        this.env.setClient(client);
    }

    public void setHostControllerName(String name) {
        this.env.setHostControllerName(name);
    }

    public void setServerName(String name) {
        this.env.setServerName(name);
    }

    private String constructUri(String protocol, String host, int port) throws URISyntaxException {
        URI uri = new URI(protocol, null, host, port, null, null, null);
        return protocol == null ? uri.toString().substring(2) : uri.toString();
    }
}

