/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.IOException;
import javax.management.MBeanServer;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.jmx.ServerInterceptorFactory;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remotingjmx.RemotingConnectorServer;
import org.jboss.remotingjmx.ServerMessageInterceptorFactory;

public class RemotingConnectorService
implements Service<RemotingConnectorServer> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jmx", "remoting-connector-ref"});
    private RemotingConnectorServer server;
    private final InjectedValue<MBeanServer> mBeanServer = new InjectedValue();
    private final InjectedValue<Endpoint> endpoint = new InjectedValue();

    public synchronized void start(StartContext context) throws StartException {
        this.server = new RemotingConnectorServer((MBeanServer)this.mBeanServer.getValue(), (Endpoint)this.endpoint.getValue(), (ServerMessageInterceptorFactory)new ServerInterceptorFactory());
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            this.server.stop();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized RemotingConnectorServer getValue() throws IllegalStateException, IllegalArgumentException {
        return this.server;
    }

    public static ServiceController<?> addService(ServiceTarget target, ServiceVerificationHandler verificationHandler, boolean useManagementEndpoint) {
        RemotingConnectorService service = new RemotingConnectorService();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(MBeanServerService.SERVICE_NAME, MBeanServer.class, service.mBeanServer);
        if (useManagementEndpoint) {
            builder.addDependency(ManagementRemotingServices.MANAGEMENT_ENDPOINT, Endpoint.class, service.endpoint);
        } else {
            builder.addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, service.endpoint);
        }
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.install();
    }
}

