/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor.secondLevelCache;

import java.security.AccessController;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Stream;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.secondLevelCache.CacheDeploymentListener;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.spi.EventListener;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.service.AliasServiceBuilder;

public class InfinispanCacheDeploymentListener
implements EventListener {
    public static final String CACHE_TYPE = "cachetype";
    public static final String CACHE_PRIVATE = "private";
    public static final String CONTAINER = "container";
    public static final String COLLECTION = "collection";
    public static final String ENTITY = "entity";
    public static final String IMMUTABLE_ENTITY = "immutable-entity";
    public static final String NAME = "name";
    public static final String NATURAL_ID = "natural-id";
    public static final String QUERY = "query";
    public static final String TIMESTAMPS = "timestamps";
    public static final String PENDING_PUTS = "pending-puts";
    public static final String CUSTOM = "custom";
    public static final String DEFAULT_CACHE_CONTAINER = "hibernate";

    public void beforeEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public void afterEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public Wrapper startCache(Classification classification, Properties properties) throws Exception {
        EmbeddedCacheManager embeddedCacheManager;
        ServiceName serviceName;
        String cache_type = properties.getProperty(CACHE_TYPE);
        String container = properties.getProperty(CONTAINER);
        ServiceName containerServiceName = ServiceName.parse((String)InfinispanRequirement.CONTAINER.resolve(container));
        if (CACHE_PRIVATE.equals(cache_type)) {
            String name = properties.getProperty(NAME);
            serviceName = ServiceName.JBOSS.append(new String[]{DEFAULT_CACHE_CONTAINER, name != null ? name : UUID.randomUUID().toString()});
            ServiceContainer target = InfinispanCacheDeploymentListener.currentServiceContainer();
            ServiceBuilder builder = new AliasServiceBuilder(serviceName, containerServiceName, EmbeddedCacheManager.class).build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ACTIVE);
            embeddedCacheManager = (EmbeddedCacheManager)ServiceContainerHelper.getValue((ServiceController)builder.install());
        } else {
            serviceName = containerServiceName;
            ServiceContainer registry = InfinispanCacheDeploymentListener.currentServiceContainer();
            embeddedCacheManager = (EmbeddedCacheManager)registry.getRequiredService(serviceName).getValue();
        }
        return new CacheWrapper(embeddedCacheManager, serviceName);
    }

    public void addCacheDependencies(Classification classification, Properties properties) {
        CapabilityServiceSupport support = CacheDeploymentListener.getInternalDeploymentCapablityServiceSupport();
        String container = properties.getProperty(CONTAINER);
        String entity = properties.getProperty(ENTITY);
        String immutableEntity = properties.getProperty(IMMUTABLE_ENTITY);
        String naturalId = properties.getProperty(NATURAL_ID);
        String collection = properties.getProperty(COLLECTION);
        String query = properties.getProperty(QUERY);
        String timestamps = properties.getProperty(TIMESTAMPS);
        String pendingPuts = properties.getProperty(PENDING_PUTS);
        String custom = properties.getProperty(CUSTOM);
        this.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, entity));
        this.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, immutableEntity));
        this.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, collection));
        this.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, naturalId));
        if (pendingPuts != null) {
            this.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, pendingPuts));
        }
        if (query != null) {
            this.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, timestamps));
            this.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, query));
        }
        if (custom != null) {
            Stream.of(custom.split("\\s+")).forEach(config -> this.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, config)));
        }
    }

    private void addDependency(ServiceName dependency) {
        if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
            JpaLogger.ROOT_LOGGER.tracef("add second level cache dependency on service '%s'", dependency.getCanonicalName());
        }
        CacheDeploymentListener.getInternalDeploymentServiceBuilder().addDependency(dependency);
    }

    public void stopCache(Classification classification, Wrapper wrapper, boolean ignoreStop) {
        if (!ignoreStop) {
            CacheWrapper cacheWrapper = (CacheWrapper)wrapper;
            if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
                JpaLogger.ROOT_LOGGER.tracef("stop second level cache by removing dependency on service '%s'", cacheWrapper.serviceName.getCanonicalName());
            }
            ServiceContainerHelper.remove((ServiceController)InfinispanCacheDeploymentListener.currentServiceContainer().getRequiredService(cacheWrapper.serviceName));
        } else if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
            CacheWrapper cacheWrapper = (CacheWrapper)wrapper;
            JpaLogger.ROOT_LOGGER.tracef("skipping stop of second level cache, will keep dependency on service '%s'", cacheWrapper.serviceName.getCanonicalName());
        }
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private static class CacheWrapper
    implements Wrapper {
        private final EmbeddedCacheManager embeddedCacheManager;
        private final ServiceName serviceName;

        public CacheWrapper(EmbeddedCacheManager embeddedCacheManager, ServiceName serviceName) {
            this.embeddedCacheManager = embeddedCacheManager;
            this.serviceName = serviceName;
        }

        public Object getValue() {
            return this.embeddedCacheManager;
        }
    }
}

