/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.classloader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.modules.ConcurrentClassLoader;

public class TempClassLoader
extends ConcurrentClassLoader {
    private final ClassLoader delegate;
    private static final String MANIFEST_MF = "META-INF" + File.separatorChar + "MANIFEST.MF";

    TempClassLoader(ClassLoader delegate) {
        super((ConcurrentClassLoader)null);
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findClass(String name, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        Class loaded = this.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        if (name.startsWith("javax.")) {
            return Class.forName(name, resolve, this.delegate);
        }
        InputStream resource = this.delegate.getResourceAsStream(name.replace('.', '/') + ".class");
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        int lastIdx = name.lastIndexOf(46);
        if (lastIdx != -1) {
            String packageName = name.substring(0, lastIdx);
            TempClassLoader tempClassLoader = this;
            synchronized (tempClassLoader) {
                Package pkg = this.findLoadedPackage(packageName);
                if (pkg == null) {
                    Manifest manifest = this.readManifestFile();
                    if (manifest != null) {
                        Attributes mainAttribute = manifest.getMainAttributes();
                        Attributes entryAttribute = manifest.getAttributes(packageName);
                        URL url = "true".equals(TempClassLoader.getDefinedAttribute(Attributes.Name.SEALED, entryAttribute, mainAttribute)) ? this.delegate.getResource(name.replace('.', '/') + ".class") : null;
                        this.definePackage(packageName, TempClassLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_TITLE, entryAttribute, mainAttribute), TempClassLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VERSION, entryAttribute, mainAttribute), TempClassLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VENDOR, entryAttribute, mainAttribute), TempClassLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_TITLE, entryAttribute, mainAttribute), TempClassLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VERSION, entryAttribute, mainAttribute), TempClassLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, entryAttribute, mainAttribute), url);
                    } else {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = resource.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, i);
            }
            buffer = baos.toByteArray();
            Class clazz = this.defineClass(name, buffer, 0, buffer.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected URL findResource(String name, boolean exportsOnly) {
        return this.delegate.getResource(name);
    }

    protected Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return this.delegate.getResources(name);
    }

    protected InputStream findResourceAsStream(String name, boolean exportsOnly) {
        return this.delegate.getResourceAsStream(name);
    }

    protected final Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest readManifestFile() {
        InputStream resource = null;
        try {
            resource = this.delegate.getResourceAsStream(MANIFEST_MF);
            Manifest manifest = resource != null ? new Manifest(resource) : null;
            return manifest;
        }
        catch (IOException e) {
            Manifest manifest = null;
            return manifest;
        }
        finally {
            if (resource != null) {
                try {
                    resource.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getDefinedAttribute(Attributes.Name name, Attributes entryAttribute, Attributes mainAttribute) {
        String value;
        String string = value = entryAttribute == null ? null : entryAttribute.getValue(name);
        return value == null ? (mainAttribute == null ? null : mainAttribute.getValue(name)) : value;
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

