/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor.secondLevelCache;

import java.security.AccessController;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.secondLevelCache.CacheDeploymentListener;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.spi.EventListener;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;

public class InfinispanCacheDeploymentListener
implements EventListener {
    public static final String CACHE_TYPE = "cachetype";
    public static final String CACHE_PRIVATE = "private";
    public static final String CONTAINER = "container";
    public static final String NAME = "name";
    public static final String CACHES = "caches";
    public static final String DEFAULT_CACHE_CONTAINER = "hibernate";

    public void beforeEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public void afterEntityManagerFactoryCreate(Classification classification, PersistenceUnitMetadata persistenceUnitMetadata) {
    }

    public Wrapper startCache(Classification classification, Properties properties) throws Exception {
        ServiceContainer target = InfinispanCacheDeploymentListener.currentServiceContainer();
        String container = properties.getProperty(CONTAINER);
        String cacheType = properties.getProperty(CACHE_TYPE);
        ServiceName containerServiceName = ServiceName.parse((String)InfinispanRequirement.CONTAINER.resolve(container));
        String name = properties.getProperty(NAME, UUID.randomUUID().toString());
        ServiceBuilder builder = target.addService(ServiceName.JBOSS.append(new String[]{DEFAULT_CACHE_CONTAINER, name}));
        Supplier manager = builder.requires(containerServiceName);
        if (CACHE_PRIVATE.equals(cacheType)) {
            String[] caches;
            for (String cache : caches = properties.getProperty(CACHES).split("\\s+")) {
                ServiceName dependencyName = ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(container, cache));
                builder.requires(dependencyName);
            }
        }
        ServiceController controller = builder.install();
        StabilityMonitor monitor = new StabilityMonitor();
        monitor.addController(controller);
        try {
            monitor.awaitStability();
            while (controller.getState() == ServiceController.State.DOWN) {
                Thread.yield();
                monitor.awaitStability();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        finally {
            monitor.removeController(controller);
        }
        return new CacheWrapper((EmbeddedCacheManager)manager.get(), controller);
    }

    public void addCacheDependencies(Classification classification, Properties properties) {
        ServiceBuilder<?> builder = CacheDeploymentListener.getInternalDeploymentServiceBuilder();
        CapabilityServiceSupport support = CacheDeploymentListener.getInternalDeploymentCapablityServiceSupport();
        String container = properties.getProperty(CONTAINER);
        for (String cache : properties.getProperty(CACHES).split("\\s+")) {
            builder.addDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, container, cache));
        }
    }

    public void stopCache(Classification classification, Wrapper wrapper) {
        ((CacheWrapper)wrapper).close();
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private static class CacheWrapper
    implements Wrapper,
    AutoCloseable {
        private final EmbeddedCacheManager embeddedCacheManager;
        private final ServiceController<?> controller;

        CacheWrapper(EmbeddedCacheManager embeddedCacheManager, ServiceController<?> controller) {
            this.embeddedCacheManager = embeddedCacheManager;
            this.controller = controller;
        }

        public Object getValue() {
            return this.embeddedCacheManager;
        }

        @Override
        public void close() {
            if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
                JpaLogger.ROOT_LOGGER.tracef("stop second level cache by removing dependency on service '%s'", this.controller.getName().getCanonicalName());
            }
            StabilityMonitor monitor = new StabilityMonitor();
            monitor.addController(this.controller);
            this.controller.setMode(ServiceController.Mode.REMOVE);
            try {
                monitor.awaitStability();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                monitor.removeController(this.controller);
            }
        }
    }
}

