/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.lang.instrument.ClassFileTransformer;
import org.jboss.as.hibernate.Hibernate51CompatibilityTransformer;
import org.jboss.as.jpa.classloader.JPADelegatingClassFileTransformer;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.DelegatingClassFileTransformer;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JPAClassFileTransformerProcessor
implements DeploymentUnitProcessor {
    private final boolean hibernate51CompatibilityTransformer = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"Hibernate51CompatibilityTransformer", (String)"false"));

    public JPAClassFileTransformerProcessor() {
        if (this.hibernate51CompatibilityTransformer) {
            JpaLogger.ROOT_LOGGER.hibernate51CompatibilityTransformerEnabled();
        }
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.setClassLoaderTransformer(deploymentUnit);
    }

    private void setClassLoaderTransformer(DeploymentUnit deploymentUnit) {
        DelegatingClassFileTransformer transformer = (DelegatingClassFileTransformer)deploymentUnit.getAttachment(DelegatingClassFileTransformer.ATTACHMENT_KEY);
        boolean appContainsPersistenceProviderJars = false;
        if (transformer != null) {
            for (ResourceRoot resourceRoot : DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit)) {
                PersistenceUnitMetadataHolder holder = (PersistenceUnitMetadataHolder)resourceRoot.getAttachment(PersistenceUnitMetadataHolder.PERSISTENCE_UNITS);
                if (holder == null) continue;
                for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                    String provider;
                    if (Configuration.needClassFileTransformer(pu)) {
                        transformer.addTransformer((ClassFileTransformer)new JPADelegatingClassFileTransformer(pu));
                    }
                    if ((provider = pu.getProperties().getProperty("jboss.as.jpa.providerModule")) == null || !provider.equals("application")) continue;
                    appContainsPersistenceProviderJars = true;
                }
            }
            if (!appContainsPersistenceProviderJars && this.hibernate51CompatibilityTransformer) {
                transformer.addTransformer((ClassFileTransformer)Hibernate51CompatibilityTransformer.getInstance());
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

