/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.config;

import jakarta.persistence.EntityManagerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class Configuration {
    public static final String PROVIDER_MODULE = "jboss.as.jpa.providerModule";
    public static final String PROVIDER_MODULE_HIBERNATE = "org.hibernate";
    public static final String PROVIDER_MODULE_HIBERNATE4_1 = "org.hibernate:4.1";
    public static final String PROVIDER_MODULE_HIBERNATE_OGM = "org.hibernate.ogm";
    public static final String PROVIDER_MODULE_ECLIPSELINK = "org.eclipse.persistence";
    public static final String PROVIDER_MODULE_TOPLINK = "oracle.toplink";
    public static final String PROVIDER_MODULE_DATANUCLEUS = "org.datanucleus";
    public static final String PROVIDER_MODULE_DATANUCLEUS_GAE = "org.datanucleus:appengine";
    public static final String PROVIDER_MODULE_OPENJPA = "org.apache.openjpa";
    public static final String PROVIDER_MODULE_DEFAULT = "org.hibernate";
    public static final String PROVIDER_CLASS_HIBERNATE4_1 = "org.hibernate.ejb.HibernatePersistence";
    public static final String PROVIDER_CLASS_HIBERNATE = "org.hibernate.jpa.HibernatePersistenceProvider";
    public static final String PROVIDER_CLASS_HIBERNATE_OGM = "org.hibernate.ogm.jpa.HibernateOgmPersistence";
    public static final String PROVIDER_CLASS_TOPLINK_ESSENTIALS = "oracle.toplink.essentials.PersistenceProvider";
    public static final String PROVIDER_CLASS_TOPLINK = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    public static final String PROVIDER_CLASS_ECLIPSELINK = "org.eclipse.persistence.jpa.PersistenceProvider";
    public static final String PROVIDER_CLASS_DATANUCLEUS = "org.datanucleus.api.jpa.PersistenceProviderImpl";
    public static final String PROVIDER_CLASS_DATANUCLEUS_GAE = "org.datanucleus.store.appengine.jpa.DatastorePersistenceProvider";
    public static final String PROVIDER_CLASS_OPENJPA = "org.apache.openjpa.persistence.PersistenceProviderImpl";
    public static final String PROVIDER_CLASS_DEFAULT = "org.hibernate.jpa.HibernatePersistenceProvider";
    public static final String PROVIDER_MODULE_APPLICATION_SUPPLIED = "application";
    public static final String ADAPTER_MODULE_OPENJPA = "org.jboss.as.jpa.openjpa";
    public static final String ADAPTER_MODULE = "jboss.as.jpa.adapterModule";
    public static final String JPA_CONTAINER_MANAGED = "jboss.as.jpa.managed";
    public static final String JPA_DEFAULT_PERSISTENCE_UNIT = "wildfly.jpa.default-unit";
    public static final String JPA_CONTAINER_CLASS_TRANSFORMER = "jboss.as.jpa.classtransformer";
    public static final String JPA_ALLOW_TWO_PHASE_BOOTSTRAP = "wildfly.jpa.twophasebootstrap";
    private static final String JPA_ALLOW_APPLICATION_DEFINED_DATASOURCE = "wildfly.jpa.applicationdatasource";
    private static final String JPA_ALLOW_DEFAULT_DATA_SOURCE_USE = "wildfly.jpa.allowdefaultdatasourceuse";
    private static final String JPA_DEFER_DETACH = "jboss.as.jpa.deferdetach";
    private static final String JPA_SKIP_QUERY_DETACH = "wildfly.jpa.skipquerydetach";
    private static final String JPA_SCOPED_PERSISTENCE_UNIT_NAME = "jboss.as.jpa.scopedname";
    public static final String ADAPTER_CLASS = "jboss.as.jpa.adapterClass";
    public static final String ALLOWJOINEDUNSYNCPC = "wildfly.jpa.allowjoinedunsync";
    public static final String SKIPMIXEDSYNCTYPECHECKING = "wildfly.jpa.skipmixedsynctypechecking";
    public static final String HIBERNATE_SEARCH_MODULE = "wildfly.jpa.hibernate.search.module";
    public static final String HIBERNATE_SEARCH_INTEGRATOR_ADAPTOR_MODULE_NAME = "org.hibernate.search.jipijapa-hibernatesearch";
    public static final String HIBERNATE_SEARCH_MODULE_MAPPER_ORM = "org.hibernate.search.mapper.orm";
    public static final String HIBERNATE_SEARCH_MODULE_MAPPER_ORM_OUTBOXPOLLING = "org.hibernate.search.mapper.orm.outboxpolling";
    public static final String HIBERNATE_SEARCH_MODULE_BACKEND_LUCENE = "org.hibernate.search.backend.lucene";
    public static final String HIBERNATE_SEARCH_MODULE_BACKEND_ELASTICSEARCH = "org.hibernate.search.backend.elasticsearch";
    public static final String HIBERNATE_SEARCH_BACKEND_TYPE = "hibernate.search.backend.type";
    public static final String HIBERNATE_SEARCH_BACKEND_TYPE_VALUE_LUCENE = "lucene";
    public static final String HIBERNATE_SEARCH_BACKEND_TYPE_VALUE_ELASTICSEARCH = "elasticsearch";
    public static final String HIBERNATE_SEARCH_COORDINATION_STRATEGY = "hibernate.search.coordination.strategy";
    public static final String HIBERNATE_SEARCH_COORDINATION_STRATEGY_VALUE_OUTBOX_POLLING = "outbox-polling";
    private static final String EE_DEFAULT_DATASOURCE = "java:comp/DefaultDataSource";
    private static final Map<String, String> providerClassToModuleName = new HashMap<String, String>();
    private static final String HIBERNATE = "Hibernate";
    private static final String HIBERNATE_ENHANCER = "hibernate.enhancer";
    private static final Map<String, String> providerClassToAdapterModuleName;

    public static String getProviderModuleNameFromProviderClassName(String providerClassName) {
        return providerClassToModuleName.get(providerClassName);
    }

    public static boolean needClassFileTransformer(PersistenceUnitMetadata pu) {
        if (pu.getProperties().containsKey(JPA_CONTAINER_CLASS_TRANSFORMER)) {
            return Boolean.parseBoolean(pu.getProperties().getProperty(JPA_CONTAINER_CLASS_TRANSFORMER));
        }
        if (Configuration.isHibernateProvider(pu.getPersistenceProviderClassName())) {
            return Configuration.isAnyHibernateEnhancerPropertySpecified(pu);
        }
        return true;
    }

    private static boolean isAnyHibernateEnhancerPropertySpecified(PersistenceUnitMetadata pu) {
        Set<String> set = pu.getProperties().stringPropertyNames();
        for (String key : set) {
            if (!key.startsWith(HIBERNATE_ENHANCER) || !Boolean.parseBoolean(pu.getProperties().getProperty(key))) continue;
            return true;
        }
        return false;
    }

    private static boolean isHibernateProvider(String provider) {
        return provider == null || provider.contains(HIBERNATE);
    }

    public static String getProviderAdapterModuleNameFromProviderClassName(String providerClassName) {
        return providerClassToAdapterModuleName.get(providerClassName);
    }

    public static String getDefaultProviderModuleName() {
        return "org.hibernate";
    }

    public static boolean allowTwoPhaseBootstrap(PersistenceUnitMetadata pu) {
        boolean result = true;
        if (EE_DEFAULT_DATASOURCE.equals(pu.getJtaDataSourceName())) {
            result = false;
        }
        if (pu.getProperties().containsKey(JPA_ALLOW_TWO_PHASE_BOOTSTRAP)) {
            result = Boolean.parseBoolean(pu.getProperties().getProperty(JPA_ALLOW_TWO_PHASE_BOOTSTRAP));
        }
        return result;
    }

    public static boolean allowApplicationDefinedDatasource(PersistenceUnitMetadata pu) {
        boolean result = false;
        if (pu.getProperties().containsKey(JPA_ALLOW_APPLICATION_DEFINED_DATASOURCE)) {
            result = Boolean.parseBoolean(pu.getProperties().getProperty(JPA_ALLOW_APPLICATION_DEFINED_DATASOURCE));
        }
        return result;
    }

    public static boolean allowDefaultDataSourceUse(PersistenceUnitMetadata pu) {
        boolean result = true;
        if (pu.getProperties().containsKey(JPA_ALLOW_DEFAULT_DATA_SOURCE_USE)) {
            result = Boolean.parseBoolean(pu.getProperties().getProperty(JPA_ALLOW_DEFAULT_DATA_SOURCE_USE));
        }
        return result;
    }

    public static boolean deferEntityDetachUntilClose(Map<String, Object> properties) {
        boolean result = false;
        if (properties.containsKey(JPA_DEFER_DETACH)) {
            result = Boolean.parseBoolean((String)properties.get(JPA_DEFER_DETACH));
        }
        return result;
    }

    public static boolean skipQueryDetach(Map<String, Object> properties) {
        boolean result = false;
        if (properties.containsKey(JPA_SKIP_QUERY_DETACH)) {
            result = Boolean.parseBoolean((String)properties.get(JPA_SKIP_QUERY_DETACH));
        }
        return result;
    }

    public static String getScopedPersistenceUnitName(PersistenceUnitMetadata pu) {
        Object name = pu.getProperties().get(JPA_SCOPED_PERSISTENCE_UNIT_NAME);
        if (name instanceof String) {
            return (String)name;
        }
        return null;
    }

    public static boolean skipMixedSynchronizationTypeCheck(EntityManagerFactory emf, Map targetEntityManagerProperties) {
        boolean result = false;
        if (targetEntityManagerProperties != null && targetEntityManagerProperties.containsKey(SKIPMIXEDSYNCTYPECHECKING)) {
            result = Boolean.parseBoolean((String)targetEntityManagerProperties.get(SKIPMIXEDSYNCTYPECHECKING));
        } else if (emf.getProperties() != null && emf.getProperties().containsKey(SKIPMIXEDSYNCTYPECHECKING)) {
            result = Boolean.parseBoolean((String)emf.getProperties().get(SKIPMIXEDSYNCTYPECHECKING));
        }
        return result;
    }

    public static boolean allowJoinedUnsyncPersistenceContext(EntityManagerFactory emf, Map targetEntityManagerProperties) {
        boolean result = false;
        if (targetEntityManagerProperties != null && targetEntityManagerProperties.containsKey(ALLOWJOINEDUNSYNCPC)) {
            result = Boolean.parseBoolean((String)targetEntityManagerProperties.get(ALLOWJOINEDUNSYNCPC));
        } else if (emf.getProperties() != null && emf.getProperties().containsKey(ALLOWJOINEDUNSYNCPC)) {
            result = Boolean.parseBoolean((String)emf.getProperties().get(ALLOWJOINEDUNSYNCPC));
        }
        return result;
    }

    static {
        providerClassToModuleName.put("org.hibernate.jpa.HibernatePersistenceProvider", "org.hibernate");
        providerClassToModuleName.put(PROVIDER_CLASS_HIBERNATE4_1, "org.hibernate");
        providerClassToModuleName.put(PROVIDER_CLASS_HIBERNATE_OGM, PROVIDER_MODULE_HIBERNATE_OGM);
        providerClassToModuleName.put(PROVIDER_CLASS_TOPLINK_ESSENTIALS, PROVIDER_MODULE_TOPLINK);
        providerClassToModuleName.put(PROVIDER_CLASS_TOPLINK, PROVIDER_MODULE_TOPLINK);
        providerClassToModuleName.put(PROVIDER_CLASS_ECLIPSELINK, PROVIDER_MODULE_ECLIPSELINK);
        providerClassToModuleName.put(PROVIDER_CLASS_DATANUCLEUS, PROVIDER_MODULE_DATANUCLEUS);
        providerClassToModuleName.put(PROVIDER_CLASS_DATANUCLEUS_GAE, PROVIDER_MODULE_DATANUCLEUS_GAE);
        providerClassToModuleName.put(PROVIDER_CLASS_OPENJPA, PROVIDER_MODULE_OPENJPA);
        providerClassToAdapterModuleName = new HashMap<String, String>();
        providerClassToAdapterModuleName.put(PROVIDER_CLASS_OPENJPA, ADAPTER_MODULE_OPENJPA);
    }
}

