/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.Map;
import java.util.ServiceLoader;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.messages.JpaMessages;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jipijapa.plugin.spi.JtaManager;
import org.jipijapa.plugin.spi.ManagementAdaptor;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class PersistenceProviderAdaptorLoader {
    private static final PersistenceProviderAdaptor noopAdaptor = new PersistenceProviderAdaptor(){

        public void injectJtaManager(JtaManager jtaManager) {
        }

        public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        }

        public void addProviderDependencies(PersistenceUnitMetadata pu) {
        }

        public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        }

        public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        }

        public ManagementAdaptor getManagementAdaptor() {
            return null;
        }

        public boolean doesScopedPersistenceUnitNameIdentifyCacheRegionName(PersistenceUnitMetadata pu) {
            return true;
        }

        public void cleanup(PersistenceUnitMetadata pu) {
        }
    };

    public static PersistenceProviderAdaptor loadPersistenceAdapterModule(String adapterModule) throws ModuleLoadException {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (adapterModule == null) {
            return noopAdaptor;
        }
        PersistenceProviderAdaptor persistenceProviderAdaptor = null;
        Module module = moduleLoader.loadModule(ModuleIdentifier.fromString((String)adapterModule));
        ServiceLoader serviceLoader = module.loadService(PersistenceProviderAdaptor.class);
        if (serviceLoader != null) {
            for (PersistenceProviderAdaptor adaptor : serviceLoader) {
                if (persistenceProviderAdaptor != null) {
                    throw JpaMessages.MESSAGES.multipleAdapters(adapterModule);
                }
                persistenceProviderAdaptor = adaptor;
                JpaLogger.JPA_LOGGER.debugf("loaded persistence provider adapter %s", adapterModule);
            }
            if (persistenceProviderAdaptor != null) {
                persistenceProviderAdaptor.injectJtaManager((JtaManager)JtaManagerImpl.getInstance());
            }
        }
        return persistenceProviderAdaptor;
    }

    public static PersistenceProviderAdaptor loadPersistenceAdapter(PersistenceProvider persistenceProvider) {
        PersistenceProviderAdaptor persistenceProviderAdaptor = null;
        ServiceLoader<PersistenceProviderAdaptor> serviceLoader = ServiceLoader.load(PersistenceProviderAdaptor.class, persistenceProvider.getClass().getClassLoader());
        if (serviceLoader != null) {
            for (PersistenceProviderAdaptor adaptor : serviceLoader) {
                if (persistenceProviderAdaptor != null) {
                    throw JpaMessages.MESSAGES.classloaderHasMultipleAdapters(persistenceProvider.getClass().getClassLoader().toString());
                }
                persistenceProviderAdaptor = adaptor;
                JpaLogger.JPA_LOGGER.debugf("loaded persistence provider adapter %s from classloader %s", persistenceProviderAdaptor.getClass().getName(), persistenceProvider.getClass().getClassLoader().toString());
            }
            if (persistenceProviderAdaptor != null) {
                persistenceProviderAdaptor.injectJtaManager((JtaManager)JtaManagerImpl.getInstance());
            }
        }
        return persistenceProviderAdaptor == null ? noopAdaptor : persistenceProviderAdaptor;
    }
}

