/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.HAPolicySynchronizationStatusReadHandler;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;
import org.wildfly.extension.messaging.activemq.ha.ScaleDownAttributes;

public class ReplicationSecondaryDefinition
extends PersistentResourceDefinition {
    public static final Collection<AttributeDefinition> ATTRIBUTES;
    private final boolean registerRuntime;

    public ReplicationSecondaryDefinition(PathElement path, boolean allowSibling, boolean registerRuntime) {
        super(path, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ManagementHelper.createAddOperation(path.getKey(), allowSibling, ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.registerRuntime = registerRuntime;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQReloadRequiredHandlers.WriteAttributeHandler writeAttribute = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeAttribute);
        }
        if (this.registerRuntime) {
            HAPolicySynchronizationStatusReadHandler.registerSlaveAttributes(resourceRegistration);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static {
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.add(HAAttributes.CLUSTER_NAME);
        attributes.add(HAAttributes.GROUP_NAME);
        attributes.add(HAAttributes.ALLOW_FAILBACK);
        attributes.add(HAAttributes.INITIAL_REPLICATION_SYNC_TIMEOUT);
        attributes.add(HAAttributes.MAX_SAVED_REPLICATED_JOURNAL_SIZE);
        attributes.add(HAAttributes.RESTART_BACKUP);
        attributes.addAll(ScaleDownAttributes.SCALE_DOWN_ATTRIBUTES);
        ATTRIBUTES = Collections.unmodifiableCollection(attributes);
    }
}

