/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.InfiniteOrPositiveValidators;

public class ScaleDownAttributes {
    private static final String SCALE_DOWN_DISCOVERY_GROUP_STR = "scale-down-discovery-group";
    private static final String SCALE_DOWN_CONNECTORS_STR = "scale-down-connectors";
    public static final SimpleAttributeDefinition SCALE_DOWN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down", (ModelType)ModelType.BOOLEAN).setAttributeGroup("scale-down")).setXmlName("enabled")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SCALE_DOWN_CLUSTER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down-cluster-name", (ModelType)ModelType.STRING).setAttributeGroup("scale-down")).setXmlName("cluster-name")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition SCALE_DOWN_COMMIT_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down-commit-interval", (ModelType)ModelType.INT).setAttributeGroup("scale-down")).setXmlName("commit-interval")).setDefaultValue(new ModelNode().set(-1))).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition SCALE_DOWN_CONNECTORS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("scale-down-connectors").setAttributeGroup("scale-down")).setXmlName("connectors")).setAlternatives(new String[]{"scale-down-discovery-group"})).setRequired(false)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setAttributeParser(AttributeParser.STRING_LIST)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SCALE_DOWN_DISCOVERY_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down-discovery-group", (ModelType)ModelType.STRING).setAttributeGroup("scale-down")).setXmlName("discovery-group")).setRequired(false)).setAlternatives(new String[]{"scale-down-connectors"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SCALE_DOWN_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scale-down-group-name", (ModelType)ModelType.STRING).setAttributeGroup("scale-down")).setXmlName("group-name")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final Collection<AttributeDefinition> SCALE_DOWN_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(SCALE_DOWN, SCALE_DOWN_CLUSTER_NAME, SCALE_DOWN_GROUP_NAME, SCALE_DOWN_DISCOVERY_GROUP, SCALE_DOWN_CONNECTORS, SCALE_DOWN_COMMIT_INTERVAL));

    static ScaleDownConfiguration addScaleDownConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode connectors;
        ModelNode discoveryGroupName;
        ModelNode groupName;
        if (!model.hasDefined(SCALE_DOWN.getName())) {
            return null;
        }
        ScaleDownConfiguration scaleDownConfiguration = new ScaleDownConfiguration();
        scaleDownConfiguration.setEnabled(SCALE_DOWN.resolveModelAttribute(context, model).asBoolean());
        ModelNode clusterName = SCALE_DOWN_CLUSTER_NAME.resolveModelAttribute(context, model);
        if (clusterName.isDefined()) {
            scaleDownConfiguration.setClusterName(clusterName.asString());
        }
        if ((groupName = SCALE_DOWN_GROUP_NAME.resolveModelAttribute(context, model)).isDefined()) {
            scaleDownConfiguration.setGroupName(groupName.asString());
        }
        if ((discoveryGroupName = SCALE_DOWN_DISCOVERY_GROUP.resolveModelAttribute(context, model)).isDefined()) {
            scaleDownConfiguration.setDiscoveryGroup(discoveryGroupName.asString());
        }
        if ((connectors = SCALE_DOWN_CONNECTORS.resolveModelAttribute(context, model)).isDefined()) {
            ArrayList connectorNames = new ArrayList(connectors.keys());
            scaleDownConfiguration.setConnectors(connectorNames);
        }
        ModelNode commitInterval = SCALE_DOWN_COMMIT_INTERVAL.resolveModelAttribute(context, model);
        scaleDownConfiguration.setCommitInterval(commitInterval.asInt());
        return scaleDownConfiguration;
    }
}

