/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.microprofile.config.EnvConfigSource;
import org.wildfly.microprofile.config.PropertiesConfigSourceProvider;
import org.wildfly.microprofile.config.SysPropConfigSource;
import org.wildfly.microprofile.config.WildFlyConfig;

public class WildFlyConfigBuilder
implements ConfigBuilder {
    private static final String META_INF_MICROPROFILE_CONFIG_PROPERTIES = "META-INF/microprofile-config.properties";
    private static final String WEB_INF_MICROPROFILE_CONFIG_PROPERTIES = "WEB-INF/classes/META-INF/microprofile-config.properties";
    private List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private List<Converter> converters = new ArrayList<Converter>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private boolean addDefaultSources = false;
    private boolean addDiscoveredSources = false;
    private boolean addDiscoveredConverters = false;

    public ConfigBuilder addDiscoveredSources() {
        this.addDiscoveredSources = true;
        return this;
    }

    public ConfigBuilder addDiscoveredConverters() {
        this.addDiscoveredConverters = true;
        return this;
    }

    private List<ConfigSource> discoverSources() {
        ArrayList<ConfigSource> discoveredSources = new ArrayList<ConfigSource>();
        ServiceLoader<ConfigSource> configSourceLoader = ServiceLoader.load(ConfigSource.class, this.classLoader);
        configSourceLoader.forEach(configSource -> discoveredSources.add((ConfigSource)configSource));
        ServiceLoader<ConfigSourceProvider> configSourceProviderLoader = ServiceLoader.load(ConfigSourceProvider.class, this.classLoader);
        configSourceProviderLoader.forEach(configSourceProvider -> configSourceProvider.getConfigSources(this.classLoader).forEach(configSource -> discoveredSources.add((ConfigSource)configSource)));
        return discoveredSources;
    }

    private List<Converter> discoverConverters() {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        ServiceLoader<Converter> converterLoader = ServiceLoader.load(Converter.class, this.classLoader);
        converterLoader.forEach(converter -> converters.add((Converter)converter));
        return converters;
    }

    public ConfigBuilder addDefaultSources() {
        this.addDefaultSources = true;
        return this;
    }

    private List<ConfigSource> getDefaultSources() {
        ArrayList<ConfigSource> defaultSources = new ArrayList<ConfigSource>();
        defaultSources.add(new EnvConfigSource());
        defaultSources.add(new SysPropConfigSource());
        defaultSources.addAll((Collection<ConfigSource>)new PropertiesConfigSourceProvider(META_INF_MICROPROFILE_CONFIG_PROPERTIES, true, this.classLoader).getConfigSources(this.classLoader));
        defaultSources.addAll((Collection<ConfigSource>)new PropertiesConfigSourceProvider(WEB_INF_MICROPROFILE_CONFIG_PROPERTIES, true, this.classLoader).getConfigSources(this.classLoader));
        return defaultSources;
    }

    public ConfigBuilder forClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ConfigBuilder withSources(ConfigSource ... configSources) {
        for (ConfigSource source : configSources) {
            this.sources.add(source);
        }
        return this;
    }

    public ConfigBuilder withConverters(Converter<?>[] converters) {
        for (Converter<?> converter : converters) {
            this.converters.add(converter);
        }
        return this;
    }

    public Config build() {
        if (this.addDiscoveredSources) {
            this.sources.addAll(this.discoverSources());
        }
        if (this.addDefaultSources) {
            this.sources.addAll(this.getDefaultSources());
        }
        if (this.addDiscoveredConverters) {
            this.converters.addAll(this.discoverConverters());
        }
        Collections.sort(this.sources, new Comparator<ConfigSource>(){

            @Override
            public int compare(ConfigSource o1, ConfigSource o2) {
                return o2.getOrdinal() - o1.getOrdinal();
            }
        });
        return new WildFlyConfig(this.sources, this.converters);
    }
}

