/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.config;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.microprofile.config.Converters;

public class WildFlyConfig
implements Config,
Serializable {
    private final List<ConfigSource> configSources;
    private Map<Type, Converter> converters;

    WildFlyConfig(List<ConfigSource> configSources, List<Converter> converters) {
        this.configSources = configSources;
        this.converters = new HashMap<Type, Converter>(Converters.ALL_CONVERTERS);
        this.addConverters(converters);
    }

    public <T> T getValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            return this.convert(value, aClass);
        }
        throw new NoSuchElementException("Property " + name + " not found");
    }

    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.configSources) {
            String value = configSource.getValue(name);
            if (value == null || value.length() <= 0) continue;
            return Optional.of(this.convert(value, aClass));
        }
        return Optional.empty();
    }

    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        for (ConfigSource configSource : this.configSources) {
            names.addAll(configSource.getProperties().keySet());
        }
        return names;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.configSources;
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value != null) {
            Converter converter = this.getConverter(asType);
            return (T)converter.convert(value);
        }
        return null;
    }

    private <T> Converter getConverter(Class<T> asType) {
        Converter converter = this.converters.get(asType);
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }

    private void addConverters(List<Converter> converters) {
        for (Converter converter : converters) {
            Type type = this.getConverterType(converter.getClass());
            if (type == null) {
                throw new IllegalStateException("Can not add converter " + converter + " that is not parameterized with a type");
            }
            this.converters.put(type, converter);
        }
    }

    private Type getConverterType(Class clazz) {
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be parameterized with a single type");
            }
            return typeArguments[0];
        }
        return this.getConverterType(clazz.getSuperclass());
    }
}

