/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.microprofile.config.spi.Converter;

class ImplicitConverters {
    ImplicitConverters() {
    }

    static Converter getConverter(Class<?> clazz) {
        for (Converter converter : new Converter[]{ImplicitConverters.getConverterFromConstructor(clazz, String.class), ImplicitConverters.getConverterFromConstructor(clazz, CharSequence.class), ImplicitConverters.getConverterFromStaticMethod(clazz, "valueOf", String.class), ImplicitConverters.getConverterFromStaticMethod(clazz, "valueOf", CharSequence.class), ImplicitConverters.getConverterFromStaticMethod(clazz, "parse", String.class), ImplicitConverters.getConverterFromStaticMethod(clazz, "parse", CharSequence.class)}) {
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    private static Converter getConverterFromConstructor(Class<?> clazz, Class<?> paramType) {
        try {
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(paramType);
            if (!declaredConstructor.isAccessible()) {
                declaredConstructor.setAccessible(true);
            }
            return value -> {
                try {
                    return declaredConstructor.newInstance(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Converter getConverterFromStaticMethod(Class<?> clazz, String methodName, Class<?> paramType) {
        try {
            Method method = clazz.getMethod(methodName, paramType);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return value -> {
                    try {
                        return method.invoke(null, value);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                };
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }
}

