/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.config.smallrye.Registry;
import org.wildfly.extension.microprofile.config.smallrye.ServiceNames;
import org.wildfly.extension.microprofile.config.smallrye._private.MicroProfileConfigLogger;

class ClassConfigSourceRegistrationService
implements Service {
    private final String name;
    private final ConfigSource configSource;
    private final Registry<ConfigSource> sources;

    ClassConfigSourceRegistrationService(String name, ConfigSource configSource, Registry<ConfigSource> sources) {
        this.name = name;
        this.configSource = configSource;
        this.sources = sources;
    }

    static void install(OperationContext context, String name, ConfigSource configSource, Registry registry) {
        ServiceBuilder builder = context.getServiceTarget().addService(ServiceNames.CONFIG_SOURCE.append(new String[]{name}));
        builder.setInstance((Service)new ClassConfigSourceRegistrationService(name, configSource, registry)).install();
    }

    public void start(StartContext startContext) {
        MicroProfileConfigLogger.ROOT_LOGGER.loadConfigSourceFromClass(this.configSource.getClass());
        this.sources.register(this.name, this.configSource);
    }

    public void stop(StopContext context) {
        this.sources.unregister(this.name);
    }
}

