/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.wildfly.extension.microprofile.config.smallrye.ConfigSourceProviderRegistrationService;
import org.wildfly.extension.microprofile.config.smallrye.MicroProfileConfigExtension;
import org.wildfly.extension.microprofile.config.smallrye.Registry;
import org.wildfly.extension.microprofile.config.smallrye._private.MicroProfileConfigLogger;

class ConfigSourceProviderDefinition
extends PersistentResourceDefinition {
    static ObjectTypeAttributeDefinition CLASS = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"class", (AttributeDefinition[])new AttributeDefinition[]{((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build()}).setRequired(false)).setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT)).setRestartAllServices()).build();
    static AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CLASS};

    protected ConfigSourceProviderDefinition(Registry<ConfigSourceProvider> providers) {
        super(new SimpleResourceDefinition.Parameters(MicroProfileConfigExtension.CONFIG_SOURCE_PROVIDER_PATH, MicroProfileConfigExtension.getResourceDescriptionResolver(MicroProfileConfigExtension.CONFIG_SOURCE_PROVIDER_PATH.getKey())).setAddHandler((OperationStepHandler)new ConfigSourceProviderDefinitionAddHandler(providers)).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    private static Class unwrapClass(ModelNode classModel) throws OperationFailedException {
        String className = classModel.get("name").asString();
        String moduleName = classModel.get("module").asString();
        try {
            Module module = Module.getCallerModuleLoader().loadModule(ModuleIdentifierUtil.canonicalModuleIdentifier((String)moduleName));
            Class clazz = module.getClassLoader().loadClass(className);
            return clazz;
        }
        catch (Exception e) {
            throw MicroProfileConfigLogger.ROOT_LOGGER.unableToLoadClassFromModule(className, moduleName);
        }
    }

    private static class ConfigSourceProviderDefinitionAddHandler
    extends AbstractAddStepHandler {
        private final Registry<ConfigSourceProvider> providers;

        private ConfigSourceProviderDefinitionAddHandler(Registry<ConfigSourceProvider> providers) {
            super(ATTRIBUTES);
            this.providers = providers;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            ModelNode classModel = CLASS.resolveModelAttribute(context, model);
            if (classModel.isDefined()) {
                Class configSourceProviderClass = ConfigSourceProviderDefinition.unwrapClass(classModel);
                try {
                    ConfigSourceProviderRegistrationService.install(context, context.getCurrentAddressValue(), (ConfigSourceProvider)ConfigSourceProvider.class.cast(configSourceProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])), this.providers);
                }
                catch (Exception e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
        }
    }
}

