/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.SmallRyeHealthReporter;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.microprofile.health.MicroProfileHealthExtension;

public class CheckOperation
extends AbstractRuntimeOnlyHandler {
    private static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("check", MicroProfileHealthExtension.getResourceDescriptionResolver("microprofile-health-smallrye")).setRuntimeOnly().setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.OBJECT).build();

    static void register(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerOperationHandler(DEFINITION, (OperationStepHandler)new CheckOperation());
    }

    private CheckOperation() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        ServiceName serviceName = context.getCapabilityServiceName("org.wildlfy.microprofile.health.reporter", SmallRyeHealthReporter.class);
        SmallRyeHealthReporter reporter = (SmallRyeHealthReporter)context.getServiceRegistry(false).getService(serviceName).getValue();
        SmallRyeHealth health = reporter.getHealth();
        ModelNode result = ModelNode.fromJSONString((String)health.getPayload().toString());
        context.getResult().set(result);
    }
}

