/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.microprofile.metrics.PrometheusCollector;
import org.wildfly.extension.microprofile.metrics.UnitConverter;
import org.wildfly.extension.microprofile.metrics._private.MicroProfileMetricsLogger;

public class MetricCollector {
    private final PrometheusCollector prometheusCollector;
    private final boolean exposeAnySubsystem;
    private String globalPrefix;
    private final List<String> exposedSubsystems;
    private final LocalModelControllerClient modelControllerClient;

    public MetricCollector(LocalModelControllerClient modelControllerClient, List<String> exposedSubsystems, String globalPrefix) {
        this.modelControllerClient = modelControllerClient;
        this.exposedSubsystems = exposedSubsystems;
        this.exposeAnySubsystem = exposedSubsystems.remove("*");
        this.globalPrefix = globalPrefix;
        this.prometheusCollector = new PrometheusCollector();
        this.prometheusCollector.register(CollectorRegistry.defaultRegistry);
    }

    void close() {
        CollectorRegistry.defaultRegistry.unregister((Collector)this.prometheusCollector);
    }

    public MetricRegistration collectResourceMetrics(Resource resource, ImmutableManagementResourceRegistration managementResourceRegistration, Function<PathAddress, PathAddress> resourceAddressResolver) {
        MetricRegistration registration = new MetricRegistration();
        this.collectResourceMetrics0(resource, managementResourceRegistration, PathAddress.EMPTY_ADDRESS, resourceAddressResolver, registration);
        return registration;
    }

    private void collectResourceMetrics0(Resource current, ImmutableManagementResourceRegistration managementResourceRegistration, PathAddress address, Function<PathAddress, PathAddress> resourceAddressResolver, MetricRegistration registration) {
        if (!this.isExposingMetrics(address)) {
            return;
        }
        Map attributes = managementResourceRegistration.getAttributes(address);
        if (attributes == null) {
            return;
        }
        ModelNode resourceDescription = null;
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            AttributeAccess attributeAccess = (AttributeAccess)entry.getValue();
            if (!this.isCollectibleMetric(attributeAccess)) continue;
            if (resourceDescription == null) {
                DescriptionProvider modelDescription = managementResourceRegistration.getModelDescription(address);
                resourceDescription = modelDescription.getModelDescription(Locale.getDefault());
            }
            PathAddress resourceAddress = resourceAddressResolver.apply(address);
            MeasurementUnit unit = attributeAccess.getAttributeDefinition().getMeasurementUnit();
            boolean counter = attributeAccess.getFlags().contains(AttributeAccess.Flag.COUNTER_METRIC);
            MetricMetadata metricMetadata = new MetricMetadata(attributeName, resourceAddress, unit, this.globalPrefix, counter);
            String attributeDescription = resourceDescription.get(new String[]{"attributes", attributeName, "description"}).asStringOrNull();
            Object metricFamilySamples = counter ? new CounterMetricFamily(metricMetadata.metricName, attributeDescription, metricMetadata.labelNames) : new GaugeMetricFamily(metricMetadata.metricName, attributeDescription, metricMetadata.labelNames);
            Supplier<Optional<Collector.MetricFamilySamples.Sample>> sampleSupplier = () -> {
                ModelNode readAttributeOp = new ModelNode();
                readAttributeOp.get("operation").set("read-attribute");
                readAttributeOp.get("address").set(resourceAddress.toModelNode());
                readAttributeOp.get("include-undefined-metric-values").set(true);
                readAttributeOp.get("name").set(attributeName);
                ModelNode response = this.modelControllerClient.execute(readAttributeOp);
                String error = this.getFailureDescription(response);
                if (error != null) {
                    throw MicroProfileMetricsLogger.LOGGER.unableToReadAttribute(attributeName, address, error);
                }
                ModelNode result = response.get("result");
                if (result.isDefined()) {
                    try {
                        double initialValue = result.asDouble();
                        double scaledValue = UnitConverter.scaleToBase(initialValue, unit);
                        return Optional.of(new Collector.MetricFamilySamples.Sample(metricMetadata.metricName, metricMetadata.labelNames, metricMetadata.labelValues, scaledValue));
                    }
                    catch (Exception e) {
                        throw MicroProfileMetricsLogger.LOGGER.unableToConvertAttribute(attributeName, address, e);
                    }
                }
                return Optional.empty();
            };
            this.prometheusCollector.addMetricFamilySampleSupplier((Collector.MetricFamilySamples)metricFamilySamples, sampleSupplier);
            registration.addUnregistrationTask(() -> this.prometheusCollector.removeMetricFamilySampleSupplier(metricMetadata.metricName, sampleSupplier));
        }
        for (String type : current.getChildTypes()) {
            if (!current.hasChildren(type)) continue;
            for (Resource.ResourceEntry entry : current.getChildren(type)) {
                PathElement pathElement = entry.getPathElement();
                PathAddress childAddress = address.append(new PathElement[]{pathElement});
                this.collectResourceMetrics0((Resource)entry, managementResourceRegistration, childAddress, resourceAddressResolver, registration);
            }
        }
    }

    private boolean isExposingMetrics(PathAddress address) {
        if (address.size() == 0) {
            return true;
        }
        String subsystemName = this.getSubsystemName(address);
        if (subsystemName != null) {
            return this.exposeAnySubsystem || this.exposedSubsystems.contains(subsystemName);
        }
        return false;
    }

    private String getSubsystemName(PathAddress address) {
        if (address.size() == 0) {
            return null;
        }
        if (address.getElement(0).getKey().equals("subsystem")) {
            return address.getElement(0).getValue();
        }
        return this.getSubsystemName(address.subAddress(1));
    }

    void collectMetricFamilies(ImmutableManagementResourceRegistration managementResourceRegistration, PathAddress address) {
        if (!this.isExposingMetrics(address)) {
            return;
        }
        ModelNode resourceDescription = null;
        Map attributes = managementResourceRegistration.getAttributes(address);
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            AttributeAccess attributeAccess = (AttributeAccess)entry.getValue();
            if (!this.isCollectibleMetric(attributeAccess)) {
                MicroProfileMetricsLogger.LOGGER.debugf("Type %s is not supported for MicroProfile Metrics, the attribute %s on %s will not be registered.", attributeAccess.getAttributeDefinition().getType(), attributeName, address);
                continue;
            }
            if (resourceDescription == null) {
                DescriptionProvider modelDescription = managementResourceRegistration.getModelDescription(address);
                resourceDescription = modelDescription.getModelDescription(Locale.getDefault());
            }
            boolean counter = attributeAccess.getFlags().contains(AttributeAccess.Flag.COUNTER_METRIC);
            MetricMetadata metricMetadata = new MetricMetadata(attributeName, address, attributeAccess.getAttributeDefinition().getMeasurementUnit(), this.globalPrefix, counter);
            String attributeDescription = resourceDescription.get(new String[]{"attributes", attributeName, "description"}).asStringOrNull();
            Object metricFamilySamples = counter ? new CounterMetricFamily(metricMetadata.metricName, attributeDescription, metricMetadata.labelNames) : new GaugeMetricFamily(metricMetadata.metricName, attributeDescription, metricMetadata.labelNames);
            this.prometheusCollector.addMetricFamilySamples((Collector.MetricFamilySamples)metricFamilySamples);
        }
        for (PathElement childAddress : managementResourceRegistration.getChildAddresses(address)) {
            this.collectMetricFamilies(managementResourceRegistration, address.append(new PathElement[]{childAddress}));
        }
    }

    private boolean isCollectibleMetric(AttributeAccess attributeAccess) {
        ModelType type;
        return attributeAccess.getAccessType() == AttributeAccess.AccessType.METRIC && attributeAccess.getStorageType() == AttributeAccess.Storage.RUNTIME && ((type = attributeAccess.getAttributeDefinition().getType()) == ModelType.INT || type == ModelType.LONG || type == ModelType.DOUBLE);
    }

    private String getFailureDescription(ModelNode result) {
        if (result.hasDefined("failure-description")) {
            return result.get("failure-description").toString();
        }
        return null;
    }

    private static class MetricMetadata {
        private static final Pattern SNAKE_CASE_PATTERN = Pattern.compile("(?<=[a-z])[A-Z]");
        private final String metricName;
        private final List<String> labelNames;
        private final List<String> labelValues;

        MetricMetadata(String attributeName, PathAddress address, MeasurementUnit unit, String globalPrefix, boolean counter) {
            String metricPrefix = "";
            this.labelNames = new ArrayList<String>();
            this.labelValues = new ArrayList<String>();
            for (PathElement element : address) {
                String key = element.getKey();
                String value = element.getValue();
                if (key.equals("subsystem") || key.equals("statistics")) {
                    metricPrefix = metricPrefix + value + "_";
                    continue;
                }
                this.labelNames.add(MetricMetadata.getPrometheusMetricName(key, null, false));
                this.labelValues.add(value);
            }
            if (this.labelNames.contains("deployment") && !this.labelNames.contains("subdeployment")) {
                this.labelNames.add("subdeployment");
                this.labelValues.add(this.labelValues.get(this.labelNames.indexOf("deployment")));
            }
            if (globalPrefix != null && !globalPrefix.isEmpty()) {
                metricPrefix = globalPrefix + "_" + metricPrefix;
            }
            this.metricName = MetricMetadata.getPrometheusMetricName(metricPrefix + attributeName, unit, counter);
        }

        private static String getPrometheusMetricName(String name, MeasurementUnit unit, boolean counter) {
            String prometheusName = name + UnitConverter.unitSuffix(unit) + (counter ? "_total" : "");
            prometheusName = prometheusName.replaceAll("[^\\w]+", "_");
            prometheusName = MetricMetadata.decamelize(prometheusName);
            return prometheusName;
        }

        private static String decamelize(String in) {
            Matcher m = SNAKE_CASE_PATTERN.matcher(in);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, "_" + m.group().toLowerCase());
            }
            m.appendTail(sb);
            return sb.toString().toLowerCase();
        }
    }

    public static final class MetricRegistration {
        private final List<Runnable> unregistrationTasks = new ArrayList<Runnable>();

        MetricRegistration() {
        }

        public void unregister() {
            for (Runnable task : this.unregistrationTasks) {
                task.run();
            }
        }

        private void addUnregistrationTask(Runnable task) {
            this.unregistrationTasks.add(task);
        }
    }
}

