package org.wildfly.extension.microprofile.metrics._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.IOException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.PathAddress;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-12-15T21:17:04-0600")
public class MicroProfileMetricsLogger_$logger extends DelegatingBasicLogger implements MicroProfileMetricsLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MicroProfileMetricsLogger_$logger.class.getName();
    public MicroProfileMetricsLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    protected String activatingSubsystem$str() {
        return "WFLYMETRICS0001: Activating Eclipse MicroProfile Metrics Subsystem";
    }
    protected String failedInitializeJMXRegistrar$str() {
        return "WFLYMETRICS0002: Failed to initialize metrics from JMX MBeans";
    }
    @Override
    public final IllegalArgumentException failedInitializeJMXRegistrar(final IOException e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failedInitializeJMXRegistrar$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unableToReadAttribute$str() {
        return "WFLYMETRICS0003: Unable to read attribute %s on %s: %s.";
    }
    @Override
    public final IllegalStateException unableToReadAttribute(final String attributeName, final PathAddress address, final String error) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToReadAttribute$str(), attributeName, address, error));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToConvertAttribute$str() {
        return "WFLYMETRICS0004: Unable to convert attribute %s on %s to Double value.";
    }
    @Override
    public final IllegalStateException unableToConvertAttribute(final String attributeName, final PathAddress address, final Exception exception) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToConvertAttribute$str(), attributeName, address), exception);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String undefinedMetric$str() {
        return "WFLYMETRICS0005: Metric attribute %s on %s is undefined and will not be exposed.";
    }
    @Override
    public final IllegalStateException undefinedMetric(final String attributeName, final PathAddress address) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), undefinedMetric$str(), attributeName, address));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
