/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.server.SpanFinishingFilter;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.wildfly.microprofile.opentracing.smallrye.TracerDynamicFeature;
import org.wildfly.microprofile.opentracing.smallrye.TracingLogger;

@WebListener
public class TracerInitializer
implements ServletContextListener {
    public static final String SMALLRYE_OPENTRACING_SERVICE_NAME = "smallrye.opentracing.serviceName";
    public static final String SMALLRYE_OPENTRACING_TRACER = "smallrye.opentracing.tracer";
    public static final String SMALLRYE_OPENTRACING_TRACER_MANAGED = "smallrye.opentracing.tracer.managed";

    public void contextInitialized(ServletContextEvent sce) {
        if (GlobalTracer.isRegistered()) {
            TracingLogger.ROOT_LOGGER.alreadyRegistered();
            return;
        }
        Tracer tracer = TracerResolver.resolveTracer();
        if (null == tracer) {
            String serviceName = sce.getServletContext().getInitParameter(SMALLRYE_OPENTRACING_SERVICE_NAME);
            if (null == serviceName || serviceName.isEmpty()) {
                TracingLogger.ROOT_LOGGER.noServiceName();
                tracer = NoopTracerFactory.create();
            } else {
                sce.getServletContext().setAttribute(SMALLRYE_OPENTRACING_TRACER_MANAGED, (Object)true);
                tracer = Configuration.fromEnv((String)serviceName).getTracer();
            }
        }
        TracingLogger.ROOT_LOGGER.registeringTracer(tracer.getClass().getName());
        sce.getServletContext().setAttribute(SMALLRYE_OPENTRACING_TRACER, (Object)tracer);
        this.addJaxRsIntegration(sce.getServletContext());
        TracingLogger.ROOT_LOGGER.initializing(tracer.toString());
    }

    private void addJaxRsIntegration(ServletContext servletContext) {
        servletContext.setInitParameter("resteasy.providers", TracerDynamicFeature.class.getName());
        FilterRegistration.Dynamic filterRegistration = servletContext.addFilter(SpanFinishingFilter.class.getName(), (Filter)new SpanFinishingFilter());
        filterRegistration.setAsyncSupported(true);
        filterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"*"});
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Object tracerObj;
        boolean isManagedTracer = false;
        Object managedTracer = sce.getServletContext().getAttribute(SMALLRYE_OPENTRACING_TRACER_MANAGED);
        if (managedTracer instanceof Boolean) {
            isManagedTracer = (Boolean)managedTracer;
        }
        if (isManagedTracer && (tracerObj = sce.getServletContext().getAttribute(SMALLRYE_OPENTRACING_TRACER)) instanceof JaegerTracer) {
            ((JaegerTracer)tracerObj).close();
        }
    }
}

