/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import io.opentracing.Tracer;
import io.smallrye.opentracing.contrib.jaxrs2.server.OperationNameProvider;
import io.smallrye.opentracing.contrib.jaxrs2.server.ServerTracingDynamicFeature;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.wildfly.microprofile.opentracing.smallrye.TracingLogger;

@Provider
public class TracerDynamicFeature
implements DynamicFeature {
    @Context
    ServletContext servletContext;
    @Inject
    Config config;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (this.config == null) {
            this.config = ConfigProvider.getConfig();
        }
        Optional skipPattern = this.config.getOptionalValue("mp.opentracing.server.skip-pattern", String.class);
        Optional operationNameProvider = this.config.getOptionalValue("mp.opentracing.server.operation-name-provider", String.class);
        Object tracerObject = this.servletContext.getAttribute("mp.opentracing.extensions.tracer");
        if (!(tracerObject instanceof Tracer)) {
            TracingLogger.ROOT_LOGGER.noTracerAvailable();
            return;
        }
        Tracer tracer = (Tracer)tracerObject;
        ServerTracingDynamicFeature.Builder builder = new ServerTracingDynamicFeature.Builder(tracer).withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.ClassNameOperationName.newBuilder()).withTraceSerialization(false);
        if (skipPattern.isPresent()) {
            builder.withSkipPattern((String)skipPattern.get());
        }
        if (operationNameProvider.isPresent()) {
            if ("http-path".equalsIgnoreCase((String)operationNameProvider.get())) {
                builder.withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.WildcardOperationName.newBuilder());
            } else if (!"class-method".equalsIgnoreCase((String)operationNameProvider.get())) {
                TracingLogger.ROOT_LOGGER.wrongOperationNameProvider();
            }
        }
        ServerTracingDynamicFeature delegate = builder.build();
        delegate.configure(resourceInfo, context);
    }
}

