/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.reactive.streams.operators.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

public class ReactiveStreamsOperatorsDependencyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.addModuleDependencies(deploymentUnit);
    }

    private void addModuleDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.eclipse.microprofile.reactive-streams-operators.core").setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.eclipse.microprofile.reactive-streams-operators.api").setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.reactivestreams").setImportServices(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"io.smallrye.reactive.mutiny.reactive-streams-operators").setImportServices(true).build());
        ModuleDependency moduleDependency = this.cdiDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"org.wildfly.reactive.mutiny.reactive-streams-operators.cdi-provider").setImportServices(true).build());
        moduleSpecification.addSystemDependency(moduleDependency);
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"io.smallrye.reactive.converters.api").setOptional(true).build());
        moduleSpecification.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)"io.smallrye.reactive.converters.rxjava2").setOptional(true).setImportServices(true).build());
    }

    private ModuleDependency cdiDependency(ModuleDependency moduleDependency) {
        moduleDependency.addImportFilter(s -> s.equals("META-INF"), true);
        return moduleDependency;
    }
}

